/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.traits;

import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public class SkipTest
implements ToSmithyBuilder<SkipTest>,
ToNode {
    private final String id;
    private final String reason;
    private final String type;

    private SkipTest(Builder builder) {
        this.id = builder.id;
        this.reason = builder.reason;
        this.type = builder.type;
    }

    public String getId() {
        return this.id;
    }

    public Optional<String> getReason() {
        return Optional.ofNullable(this.reason);
    }

    public Optional<String> getType() {
        return Optional.ofNullable(this.type);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Node toNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withMember("id", this.getId()).withOptionalMember("reason", this.getReason().map(Node::from)).withOptionalMember("type", this.getType().map(Node::from));
        return builder.build();
    }

    public static SkipTest fromNode(Node node) {
        ObjectNode objectNode = node.expectObjectNode();
        String idValue = objectNode.getMember("id").map(v -> v.expectStringNode().getValue()).orElse(null);
        String reasonValue = objectNode.getMember("reason").map(v -> v.expectStringNode().getValue()).orElse(null);
        String typeValue = objectNode.getMember("type").map(v -> v.expectStringNode().getValue()).orElse(null);
        return SkipTest.builder().id(idValue).reason(reasonValue).type(typeValue).build();
    }

    public SmithyBuilder<SkipTest> toBuilder() {
        return SkipTest.builder().id(this.id).reason(this.reason).type(this.type);
    }

    public static final class Builder
    implements SmithyBuilder<SkipTest> {
        private String id;
        private String reason;
        private String type;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public SkipTest build() {
            return new SkipTest(this);
        }
    }
}

