/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.rulesengine;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import software.amazon.smithy.build.SmithyBuildException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.WriteAdditionalFiles;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;
import software.amazon.smithy.ruby.codegen.util.RubySource;
import software.amazon.smithy.rulesengine.language.syntax.parameters.BuiltIns;
import software.amazon.smithy.rulesengine.language.syntax.parameters.Parameter;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.StringUtils;

public final class BuiltInBinding {
    private final Parameter builtIn;
    private final Set<ClientConfig> clientConfig;
    private final RenderBuild renderBuild;
    private final RenderTestSet renderTestSet;
    private final WriteAdditionalFiles writeAdditionalFiles;

    private BuiltInBinding(Builder builder) {
        this.builtIn = builder.builtIn;
        this.clientConfig = builder.clientConfig;
        this.renderBuild = builder.renderBuild;
        this.renderTestSet = builder.renderTestSet;
        this.writeAdditionalFiles = builder.writeAdditionalFiles;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Set<BuiltInBinding> defaultBuiltInBindings() {
        return Set.of(BuiltInBinding.builder().builtIn(BuiltIns.SDK_ENDPOINT).fromConfig(ClientConfig.builder().name("endpoint").documentationRbsAndValidationType("String").documentation("Endpoint of the service").defaultDynamicValue("cfg[:stub_responses] ? 'http://localhost' : nil").build()).build());
    }

    public Parameter getBuiltIn() {
        return this.builtIn;
    }

    public Set<ClientConfig> getClientConfig() {
        return this.clientConfig;
    }

    public void renderBuild(RubyCodeWriter writer, GenerationContext context, OperationShape operation) {
        this.renderBuild.renderBuild(writer, this, operation, context);
    }

    public void renderTestSet(RubyCodeWriter writer, GenerationContext context, Node value, OperationShape operation) {
        this.renderTestSet.renderTestSet(writer, this, value, operation, context);
    }

    public List<String> writeAdditionalFiles(GenerationContext context) {
        return this.writeAdditionalFiles.writeAdditionalFiles(context);
    }

    public int hashCode() {
        return Objects.hash(this.builtIn);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BuiltInBinding)) {
            return false;
        }
        BuiltInBinding other = (BuiltInBinding)o;
        return this.builtIn.equals((Object)other.builtIn);
    }

    public static class Builder
    implements SmithyBuilder<BuiltInBinding> {
        private final Set<ClientConfig> clientConfig = new HashSet<ClientConfig>();
        private Parameter builtIn;
        private RenderBuild renderBuild;
        private RenderTestSet renderTestSet;
        private WriteAdditionalFiles writeAdditionalFiles = context -> Collections.emptyList();

        public Builder builtIn(Parameter builtIn) {
            if (!builtIn.isBuiltIn()) {
                throw new SmithyBuildException("Parameter provided to BuiltInBinding must be a BuiltIn");
            }
            this.builtIn = builtIn;
            return this;
        }

        public Builder fromConfig(ClientConfig config) {
            this.clientConfig.add(config);
            this.renderBuild = (writer, builtInBinding, operation, context) -> writer.write("params.$1L = config[:$2L] unless config[:$2L].nil?", new Object[]{RubyFormatter.toSnakeCase(builtInBinding.builtIn.getName().toString()), config.getName()});
            this.renderTestSet = (writer, builtInBinding, value, operation, context) -> {
                String v = value.isStringNode() ? StringUtils.escapeJavaString((Object)value.expectStringNode().getValue(), (String)"") : (value.expectBooleanNode().getValue() ? "true" : "false");
                writer.write("config[:$L] = $L", new Object[]{config.getName(), v});
            };
            return this;
        }

        public Builder fromConstantValue(String value) {
            this.renderBuild = (writer, builtInBinding, operation, context) -> writer.write("params.$1L = $2L", new Object[]{RubyFormatter.toSnakeCase(builtInBinding.builtIn.getName().toString()), value});
            this.renderTestSet = (writer, builtInBinding, expectValue, operation, context) -> {
                String v = expectValue.isStringNode() ? StringUtils.escapeJavaString((Object)expectValue.expectStringNode().getValue(), (String)"") : (expectValue.expectBooleanNode().getValue() ? "true" : "false");
                writer.write("allow_any_instance_of(Params).to receive(:$L).and_return($L)", new Object[]{RubyFormatter.toSnakeCase(builtInBinding.builtIn.getName().toString()), v});
            };
            return this;
        }

        public Builder writeAdditionalFiles(WriteAdditionalFiles w) {
            this.writeAdditionalFiles = Objects.requireNonNull(w);
            return this;
        }

        public Builder rubySource(String rubyFileName) {
            this.writeAdditionalFiles = RubySource.rubySource(rubyFileName, "endpoint/");
            return this;
        }

        public Builder addConfig(ClientConfig config) {
            this.clientConfig.add(Objects.requireNonNull(config));
            return this;
        }

        public Builder renderBuild(RenderBuild renderBuild) {
            this.renderBuild = renderBuild;
            return this;
        }

        public Builder renderTestSet(RenderTestSet renderTestSet) {
            this.renderTestSet = renderTestSet;
            return this;
        }

        public BuiltInBinding build() {
            return new BuiltInBinding(this);
        }
    }

    @FunctionalInterface
    public static interface RenderBuild {
        public void renderBuild(RubyCodeWriter var1, BuiltInBinding var2, OperationShape var3, GenerationContext var4);
    }

    @FunctionalInterface
    public static interface RenderTestSet {
        public void renderTestSet(RubyCodeWriter var1, BuiltInBinding var2, Node var3, OperationShape var4, GenerationContext var5);
    }
}

