/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.middleware.factories;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;
import software.amazon.smithy.ruby.codegen.middleware.Middleware;
import software.amazon.smithy.ruby.codegen.middleware.MiddlewareStackStep;

public final class ValidateMiddlewareFactory {
    private ValidateMiddlewareFactory() {
    }

    public static Middleware build(GenerationContext context) {
        SymbolProvider symbolProvider = context.symbolProvider();
        String validateInputDocumentation = "When `true`, request parameters are validated using the modeled shapes.\n";
        ClientConfig validateInput = ClientConfig.builder().name("validate_input").defaultValue("true").documentation(validateInputDocumentation).documentationRbsAndValidationType("Boolean").build();
        return Middleware.builder().klass(Hearth.VALIDATE_MIDDLEWARE).step(MiddlewareStackStep.VALIDATE).operationParams((ctx, operation) -> {
            ShapeId inputShapeId = operation.getInputShape();
            Shape inputShape = ctx.model().expectShape(inputShapeId);
            HashMap<String, CallSite> params = new HashMap<String, CallSite>();
            params.put("validator", (CallSite)((Object)("Validators::" + symbolProvider.toSymbol(inputShape).getName())));
            return params;
        }).addConfig(validateInput).build();
    }
}

