/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.middleware.factories;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;
import software.amazon.smithy.ruby.codegen.config.RespondsToConstraint;
import software.amazon.smithy.ruby.codegen.middleware.Middleware;
import software.amazon.smithy.ruby.codegen.middleware.MiddlewareStackStep;

public final class EndpointMiddlewareFactory {
    private EndpointMiddlewareFactory() {
    }

    public static Middleware build(GenerationContext context) {
        String endpointResolverDocumentation = "The endpoint resolver used to resolve endpoints. Any object that responds to\n`#resolve(parameters)`\n";
        ClientConfig endpointResolverConfig = ClientConfig.builder().name("endpoint_resolver").defaultValue("Endpoint::Resolver.new").documentation(endpointResolverDocumentation).documentationType("#resolve(params)").rbsType("Hearth::_EndpointResolver[Endpoint::Params]").constraint(new RespondsToConstraint(List.of("resolve"))).build();
        return Middleware.builder().klass(Hearth.ENDPOINT_MIDDLEWARE).step(MiddlewareStackStep.AFTER_BUILD).addConfig(endpointResolverConfig).relative(Middleware.Relative.builder().after(Hearth.AUTH_MIDDLEWARE).build()).operationParams((ctx, operation) -> {
            HashMap<String, CallSite> params = new HashMap<String, CallSite>();
            params.put("param_builder", (CallSite)((Object)("Endpoint::Parameters::" + context.symbolProvider().toSymbol((Shape)operation).getName())));
            context.getBuiltInBindingsFromEndpointRules().forEach(b -> b.getClientConfig().forEach(c -> params.put(c.getName(), (CallSite)((Object)c.renderGetConfigValue()))));
            context.getModeledClientConfig().forEach(c -> params.put(c.getName(), (CallSite)((Object)c.renderGetConfigValue())));
            return params;
        }).build();
    }
}

