/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.middleware.factories;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.auth.AuthParam;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;
import software.amazon.smithy.ruby.codegen.config.RespondsToConstraint;
import software.amazon.smithy.ruby.codegen.middleware.Middleware;
import software.amazon.smithy.ruby.codegen.middleware.MiddlewareStackStep;

public final class AuthMiddlewareFactory {
    private AuthMiddlewareFactory() {
    }

    public static Middleware build(GenerationContext context) {
        ClientConfig authResolver = AuthMiddlewareFactory.buildAuthResolverConfig();
        ClientConfig authSchemesConfig = AuthMiddlewareFactory.buildAuthSchemesConfig();
        HashSet identityProvidersConfigSet = new HashSet();
        HashMap identityProvidersMap = new HashMap();
        context.getServiceAuthSchemes().forEach(authScheme -> authScheme.getIdentityProviderConfig().ifPresent(config -> {
            identityProvidersConfigSet.add(config);
            identityProvidersMap.put(authScheme.getRubyIdentityType(), config.renderGetConfigValue());
        }));
        Middleware.Builder authBuilder = Middleware.builder().klass(Hearth.AUTH_MIDDLEWARE).step(MiddlewareStackStep.AFTER_BUILD).addConfig(authResolver).addConfig(authSchemesConfig).renderAdd((writer, middleware, context1, operation) -> {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("auth_resolver", authResolver.renderGetConfigValue());
            params.put("auth_schemes", authSchemesConfig.renderGetConfigValue());
            String authParams = "Auth::Params.new(%s)".formatted(context.getAuthParams().stream().sorted(Comparator.comparing(AuthParam::getName)).map(p -> "%s: %s".formatted(p.getName(), p.renderParamValue(context, operation))).collect(Collectors.joining(", ")));
            params.put("auth_params", authParams);
            String staticParamsBlock = params.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining(",\n"));
            String identityProvidersBlock = identityProvidersMap.entrySet().stream().map(entry -> "%s => %s".formatted(entry.getKey(), entry.getValue())).collect(Collectors.joining(",\n"));
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.write("stack.use($L,", new Object[]{middleware.getKlass()})).indent()).writeInline(staticParamsBlock, new Object[0])).call(() -> {
                if (!identityProvidersBlock.isEmpty()) {
                    writer.writeInline(",\n$L", new Object[]{identityProvidersBlock});
                }
            })).dedent()).write("\n)", new Object[0]);
        });
        identityProvidersConfigSet.forEach(authBuilder::addConfig);
        context.getServiceAuthSchemes().forEach(authScheme -> authScheme.getAdditionalConfig().forEach(authBuilder::addConfig));
        return authBuilder.build();
    }

    private static ClientConfig buildAuthResolverConfig() {
        String authResolverDocumentation = "A class that responds to a `resolve(auth_params)` method where `auth_params` is\nthe {Auth::Params} struct. For a given operation_name, the method must return an\nordered list of {%s} objects to be considered for authentication.\n".formatted(Hearth.AUTH_OPTION);
        return ClientConfig.builder().name("auth_resolver").defaultValue("Auth::Resolver.new").documentation(authResolverDocumentation).documentationType("#resolve(params)").rbsType("Hearth::_AuthResolver[Auth::Params]").documentationDefaultValue("Auth::Resolver.new").constraint(new RespondsToConstraint(List.of("resolve"))).build();
    }

    private static ClientConfig buildAuthSchemesConfig() {
        String authSchemesDocumentation = "An ordered list of {%s} objects that will considered when attempting to authenticate\nthe request. The first scheme that returns an Identity from its %s will be used to\nauthenticate the request.\n".formatted(Hearth.AUTH_SCHEMES + "::Base", Hearth.IDENTITY_PROVIDER);
        return ClientConfig.builder().name("auth_schemes").defaultValue("Auth::SCHEMES").rbsType("Array[" + Hearth.AUTH_SCHEMES + "::Base]").documentationType("Array<" + Hearth.AUTH_SCHEMES + "::Base>").validateType("Array").documentation(authSchemesDocumentation).build();
    }
}

