/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.middleware;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.OperationPredicate;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.ServicePredicate;
import software.amazon.smithy.ruby.codegen.WriteAdditionalFiles;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;
import software.amazon.smithy.ruby.codegen.middleware.MiddlewareStackStep;
import software.amazon.smithy.ruby.codegen.util.RubySource;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class Middleware {
    private final String klass;
    private final MiddlewareStackStep step;
    private final byte order;
    private final Optional<Relative> relative;
    private final Set<ClientConfig> clientConfig;
    private final OperationParams operationParams;
    private final Map<String, String> additionalParams;
    private final ServicePredicate servicePredicate;
    private final OperationPredicate operationPredicate;
    private final RenderAdd renderAdd;
    private final WriteAdditionalFiles writeAdditionalFiles;

    private Middleware(Builder builder) {
        this.klass = builder.klass;
        this.step = builder.step;
        this.order = builder.order;
        this.relative = builder.relative;
        this.clientConfig = builder.clientConfig;
        this.operationParams = builder.operationParams;
        this.additionalParams = builder.additionalParams;
        this.servicePredicate = builder.servicePredicate;
        this.operationPredicate = builder.operationPredicate;
        this.renderAdd = builder.renderAdd;
        this.writeAdditionalFiles = builder.writeAdditionalFiles;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getKlass() {
        return this.klass;
    }

    public MiddlewareStackStep getStep() {
        return this.step;
    }

    public byte getOrder() {
        return this.order;
    }

    public Optional<Relative> getRelative() {
        return this.relative;
    }

    public Set<ClientConfig> getClientConfig() {
        return this.clientConfig;
    }

    public Map<String, String> getAdditionalParams() {
        return this.additionalParams;
    }

    public boolean includeFor(Model model, ServiceShape service) {
        return this.servicePredicate.test(model, service);
    }

    public boolean includeFor(Model model, ServiceShape service, OperationShape operation) {
        return this.operationPredicate.test(model, service, operation);
    }

    public void renderAdd(RubyCodeWriter writer, GenerationContext context, OperationShape operation) {
        this.renderAdd.renderAdd(writer, this, context, operation);
    }

    public List<String> writeAdditionalFiles(GenerationContext context) {
        return this.writeAdditionalFiles.writeAdditionalFiles(context);
    }

    public static class Builder
    implements SmithyBuilder<Middleware> {
        private static final RenderAdd DEFAULT_RENDER_ADD = (writer, middleware, context, operation) -> {
            Set<ClientConfig> config = middleware.getClientConfig();
            HashMap<String, String> params = new HashMap<String, String>(middleware.getAdditionalParams());
            params.putAll(middleware.operationParams.params(context, operation));
            config.stream().forEach(c -> params.put(c.getName(), c.renderGetConfigValue()));
            if (params.isEmpty()) {
                writer.write("stack.use($L)", new Object[]{middleware.getKlass()});
            } else {
                writer.write("stack.use($L,", new Object[]{middleware.getKlass()});
                writer.indent();
                String methodArgsBlock = params.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining(",\n"));
                writer.writeInline(methodArgsBlock, new Object[0]);
                writer.dedent();
                writer.write("\n)", new Object[0]);
            }
        };
        private byte order = 0;
        private Optional<Relative> relative = Optional.empty();
        private String klass;
        private MiddlewareStackStep step;
        private Set<ClientConfig> clientConfig = new HashSet<ClientConfig>();
        private OperationParams operationParams = (context, operation) -> new HashMap();
        private Map<String, String> additionalParams = new HashMap<String, String>();
        private ServicePredicate servicePredicate = (model, service) -> true;
        private OperationPredicate operationPredicate = (model, service, operation) -> true;
        private RenderAdd renderAdd = DEFAULT_RENDER_ADD;
        private WriteAdditionalFiles writeAdditionalFiles = context -> Collections.emptyList();

        protected Builder() {
        }

        public Builder klass(String klass) {
            this.klass = klass;
            return this;
        }

        public Builder klass(Symbol klass) {
            this.klass = klass.toString();
            return this;
        }

        public Builder order(byte order) {
            if (this.relative.isPresent()) {
                throw new IllegalArgumentException("Cannot combine relative ordering with explicit order value.");
            }
            this.order = order;
            return this;
        }

        public Builder relative(Relative relative) {
            if (this.order != 0) {
                throw new IllegalArgumentException("Cannot combine relative ordering with explicit order value.");
            }
            this.relative = Optional.of(relative);
            return this;
        }

        public Builder step(MiddlewareStackStep step) {
            this.step = step;
            return this;
        }

        public Builder addConfig(ClientConfig config) {
            this.clientConfig.add(Objects.requireNonNull(config));
            return this;
        }

        public Builder config(Collection<ClientConfig> config) {
            this.clientConfig = new HashSet<ClientConfig>(config);
            return this;
        }

        public Builder addParam(String name, String value) {
            this.additionalParams.put(name, value);
            return this;
        }

        public Builder params(Map<String, String> newParams) {
            this.additionalParams = new HashMap<String, String>(newParams);
            return this;
        }

        public Builder appliesOnlyToOperations(String ... operationNames) {
            return this.appliesOnlyToOperations(new HashSet<String>(Arrays.asList(operationNames)));
        }

        public Builder appliesOnlyToOperations(Set<String> operationNames) {
            return this.operationPredicate((model, service, operation) -> operationNames.contains(operation.getId().getName()));
        }

        public Builder operationPredicate(OperationPredicate p) {
            this.operationPredicate = Objects.requireNonNull(p);
            return this;
        }

        public Builder appliesOnlyToServices(Set<String> serviceNames) {
            return this.servicePredicate((model, service) -> serviceNames.contains(service.getId().getName()));
        }

        public Builder servicePredicate(ServicePredicate p) {
            this.servicePredicate = Objects.requireNonNull(p);
            return this;
        }

        public Builder operationParams(OperationParams p) {
            this.operationParams = p;
            return this;
        }

        public Builder renderAdd(RenderAdd r) {
            this.renderAdd = Objects.requireNonNull(r);
            return this;
        }

        public Builder writeAdditionalFiles(WriteAdditionalFiles w) {
            this.writeAdditionalFiles = Objects.requireNonNull(w);
            return this;
        }

        public Builder rubySource(String rubyFileName) {
            this.writeAdditionalFiles = RubySource.rubySource(rubyFileName, "middleware/");
            return this;
        }

        public Middleware build() {
            return new Middleware(this);
        }
    }

    @FunctionalInterface
    public static interface OperationParams {
        public Map<String, String> params(GenerationContext var1, OperationShape var2);
    }

    @FunctionalInterface
    public static interface RenderAdd {
        public void renderAdd(RubyCodeWriter var1, Middleware var2, GenerationContext var3, OperationShape var4);
    }

    public static class Relative {
        private final Type type;
        private final String to;
        private final boolean relativeRequired;

        public Relative(Builder builder) {
            this.type = builder.type;
            this.to = builder.to;
            this.relativeRequired = builder.relativeRequired;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Type getType() {
            return this.type;
        }

        public String getTo() {
            return this.to;
        }

        public boolean getRelativeRequired() {
            return this.relativeRequired;
        }

        public String toString() {
            return this.type + " " + this.to;
        }

        public static class Builder
        implements SmithyBuilder<Relative> {
            private Type type;
            private String to;
            private boolean relativeRequired = true;

            public Builder before(String to) {
                this.to = to;
                this.type = Type.BEFORE;
                return this;
            }

            public Builder before(Symbol to) {
                this.to = to.toString();
                this.type = Type.BEFORE;
                return this;
            }

            public Builder after(String to) {
                this.to = to;
                this.type = Type.AFTER;
                return this;
            }

            public Builder after(Symbol to) {
                this.to = to.toString();
                this.type = Type.AFTER;
                return this;
            }

            public Builder optional() {
                this.relativeRequired = false;
                return this;
            }

            public Relative build() {
                return new Relative(this);
            }
        }

        public static enum Type {
            BEFORE,
            AFTER;

        }
    }
}

