/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators.docs;

import java.util.Optional;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.traits.ExamplesTrait;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.util.ParamsToHash;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class TraitExampleGenerator {
    private final OperationShape operation;
    private final SymbolProvider symbolProvider;
    private final Model model;
    private final RubyCodeWriter writer;
    private final Optional<String> documentation;
    private final ObjectNode input;
    private final Node output;
    private final Optional<ExamplesTrait.ErrorExample> error;
    private final String operationName;
    private final Shape operationInput;
    private final Shape operationOutput;

    public TraitExampleGenerator(OperationShape operation, SymbolProvider symbolProvider, Model model, ExamplesTrait.Example example) {
        this.operation = operation;
        this.symbolProvider = symbolProvider;
        this.model = model;
        this.writer = new RubyCodeWriter("");
        this.documentation = example.getDocumentation();
        this.input = example.getInput();
        this.output = example.getOutput().isPresent() ? (Node)example.getOutput().get() : ObjectNode.nullNode();
        this.error = example.getError();
        this.operationName = RubyFormatter.toSnakeCase(symbolProvider.toSymbol((Shape)operation).getName());
        this.operationInput = model.expectShape(operation.getInputShape());
        this.operationOutput = model.expectShape(operation.getOutputShape());
    }

    public String generate() {
        if (this.error.isPresent()) {
            this.generateExampleWithError(this.error.get());
        } else {
            this.generateExample();
        }
        return this.writer.toString();
    }

    private void generateExample() {
        this.generateExampleInput();
        ((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).write("# resp.to_h outputs the following:", new Object[0])).write(this.operationOutput.accept((ShapeVisitor)new ParamsToHash(this.model, this.output, this.symbolProvider)), new Object[0]);
    }

    private void generateExampleWithError(ExamplesTrait.ErrorExample errorExample) {
        Shape errorShape = this.model.expectShape(errorExample.getShapeId());
        this.writer.openBlock("begin", new Object[0]);
        this.generateExampleInput();
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.dedent()).write("rescue ApiError => e", new Object[0])).indent()).write("puts e.class # $L", new Object[]{this.symbolProvider.toSymbol(errorShape).getName()})).write("puts e.data.to_h", new Object[0])).closeBlock("end", new Object[0])).write("", new Object[0])).write("# e.data.to_h outputs the following:", new Object[0])).write(errorShape.accept((ShapeVisitor)new ParamsToHash(this.model, (Node)errorExample.getContent(), this.symbolProvider)), new Object[0]);
    }

    private void generateExampleInput() {
        if (this.input.isEmpty()) {
            this.writer.write("resp = client.$L()", new Object[]{this.operationName});
        } else {
            if (this.documentation.isPresent()) {
                this.writer.writeDocstring(this.documentation.get());
            }
            ((RubyCodeWriter)((RubyCodeWriter)this.writer.writeInline("resp = client.$L(", new Object[]{this.operationName})).writeInline(this.operationInput.accept((ShapeVisitor)new ParamsToHash(this.model, (Node)this.input, this.symbolProvider)), new Object[0])).write(")", new Object[0]);
        }
    }
}

