/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.ruby.codegen.CodegenUtils;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.generators.RestParserGeneratorBase;
import software.amazon.smithy.ruby.codegen.util.Streaming;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public abstract class ParserGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger(RestParserGeneratorBase.class.getName());
    protected final GenerationContext context;
    protected final RubySettings settings;
    protected final Model model;
    protected final Set<ShapeId> generatedParsers;
    protected final SymbolProvider symbolProvider;
    protected final RubyCodeWriter writer;

    public ParserGeneratorBase(GenerationContext context) {
        this.context = context;
        this.settings = context.settings();
        this.model = context.model();
        this.generatedParsers = new HashSet<ShapeId>();
        this.writer = new RubyCodeWriter(context.settings().getModule() + "::Parsers");
        this.symbolProvider = context.symbolProvider();
    }

    protected abstract void renderUnionParseMethod(UnionShape var1);

    protected abstract void renderMapParseMethod(MapShape var1);

    protected abstract void renderListParseMethod(ListShape var1);

    protected abstract void renderStructureParseMethod(StructureShape var1);

    protected abstract void renderOperationParseMethod(OperationShape var1, Shape var2);

    protected abstract void renderErrorParseMethod(Shape var1);

    public void render(FileManifest fileManifest) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.preamble().includeRequires().openBlock("module $L", new Object[]{this.settings.getModule()})).apiPrivate().openBlock("module Parsers", new Object[0])).call(() -> this.renderParsers())).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
        String fileName = this.settings.getGemName() + "/lib/" + this.settings.getGemName() + "/parsers.rb";
        fileManifest.writeFile(fileName, this.writer.toString());
        LOGGER.fine("Wrote parsers to " + fileName);
    }

    protected void renderParsers() {
        TreeSet<Shape> shapesToBeRendered = CodegenUtils.getAlphabeticalOrderedShapesSet();
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        TreeSet containedOperations = new TreeSet(topDownIndex.getContainedOperations((ToShapeId)this.context.service()));
        containedOperations.stream().filter(o -> !Streaming.isEventStreaming(this.model, o)).sorted(Comparator.comparing(o -> o.getId().getName())).forEach(o -> {
            Shape outputShape = this.model.expectShape(o.getOutputShape());
            shapesToBeRendered.add((Shape)o);
            this.generatedParsers.add(o.toShapeId());
            this.generatedParsers.add(outputShape.toShapeId());
            Iterator it = new Walker(this.model).iterateShapes(outputShape);
            while (it.hasNext()) {
                Shape s = (Shape)it.next();
                if (this.generatedParsers.contains(s.getId())) continue;
                this.generatedParsers.add(s.getId());
                shapesToBeRendered.add(s);
            }
            for (ShapeId errorShapeId : o.getErrors()) {
                Iterator errIt = new Walker(this.model).iterateShapes(this.model.expectShape(errorShapeId));
                while (errIt.hasNext()) {
                    Shape s = (Shape)errIt.next();
                    if (this.generatedParsers.contains(s.getId())) continue;
                    this.generatedParsers.add(s.getId());
                    shapesToBeRendered.add(s);
                }
            }
        });
        shapesToBeRendered.forEach(shape -> {
            if (shape instanceof OperationShape) {
                OperationShape operation = (OperationShape)shape;
                Shape outputShape = this.model.expectShape(operation.getOutputShape());
                this.renderParsersForOperation(operation, outputShape);
            } else if (shape.hasTrait(ErrorTrait.class)) {
                this.renderErrorParser((Shape)shape);
            } else {
                shape.accept((ShapeVisitor)new ParserClassGenerator());
            }
        });
    }

    protected void renderParsersForOperation(OperationShape operation, Shape outputShape) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{this.symbolProvider.toSymbol((Shape)operation).getName()})).call(() -> this.renderOperationParseMethod(operation, outputShape))).closeBlock("end", new Object[0]);
    }

    protected void renderErrorParser(Shape s) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.write("", new Object[0])).write("# Error Parser for $L", new Object[]{s.getId().getName()})).openBlock("class $L", new Object[]{this.symbolProvider.toSymbol(s).getName()})).call(() -> this.renderErrorParseMethod(s))).closeBlock("end", new Object[0]);
    }

    protected void renderStreamingBodyParser(Shape outputShape) {
        MemberShape streamingMember = outputShape.members().stream().filter(m -> m.getMemberTrait(this.model, StreamingTrait.class).isPresent()).findFirst().get();
        this.writer.write("data.$L = http_resp.body", new Object[]{this.symbolProvider.toMemberName(streamingMember)});
    }

    private class ParserClassGenerator
    extends ShapeVisitor.Default<Void> {
        private ParserClassGenerator() {
        }

        protected Void getDefault(Shape shape) {
            return null;
        }

        public Void structureShape(StructureShape s) {
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)ParserGeneratorBase.this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{ParserGeneratorBase.this.symbolProvider.toSymbol((Shape)s).getName()})).call(() -> ParserGeneratorBase.this.renderStructureParseMethod(s))).closeBlock("end", new Object[0]);
            return null;
        }

        public Void listShape(ListShape s) {
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)ParserGeneratorBase.this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{ParserGeneratorBase.this.symbolProvider.toSymbol((Shape)s).getName()})).call(() -> ParserGeneratorBase.this.renderListParseMethod(s))).closeBlock("end", new Object[0]);
            return null;
        }

        public Void mapShape(MapShape s) {
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)ParserGeneratorBase.this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{ParserGeneratorBase.this.symbolProvider.toSymbol((Shape)s).getName()})).call(() -> ParserGeneratorBase.this.renderMapParseMethod(s))).closeBlock("end", new Object[0]);
            return null;
        }

        public Void unionShape(UnionShape s) {
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)ParserGeneratorBase.this.writer.write("", new Object[0])).openBlock("class $L", new Object[]{ParserGeneratorBase.this.symbolProvider.toSymbol((Shape)s).getName()})).call(() -> ParserGeneratorBase.this.renderUnionParseMethod(s))).closeBlock("end", new Object[0]);
            return null;
        }
    }
}

