/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.directed.ContextualDirective;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.PaginatedIndex;
import software.amazon.smithy.model.knowledge.PaginationInfo;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.generators.RubyGeneratorBase;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class PaginatorsGenerator
extends RubyGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger(PaginatorsGenerator.class.getName());

    public PaginatorsGenerator(ContextualDirective<GenerationContext, RubySettings> directive) {
        super(directive);
    }

    @Override
    String getModule() {
        return "Paginators";
    }

    public void render() {
        this.write(writer -> ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.preamble().includeRequires().openBlock("module $L", new Object[]{this.settings.getModule()})).openBlock("module Paginators", new Object[0])).call(() -> this.renderPaginators((RubyCodeWriter)((Object)writer)))).write("", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]));
        LOGGER.fine("Wrote paginators to " + this.rbFile());
    }

    public void renderRbs() {
        this.writeRbs(writer -> ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.preamble().openBlock("module $L", new Object[]{this.settings.getModule()})).openBlock("module Paginators", new Object[0])).call(() -> this.renderRbsPaginators((RubyCodeWriter)((Object)writer)))).write("", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]));
        LOGGER.fine("Wrote paginators rbs to " + this.rbsFile());
    }

    private void renderPaginators(RubyCodeWriter writer) {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        PaginatedIndex paginatedIndex = PaginatedIndex.of((Model)this.model);
        topDownIndex.getContainedOperations((ToShapeId)this.context.service()).stream().forEach(operation -> {
            Optional paginationInfoOptional = paginatedIndex.getPaginationInfo((ToShapeId)this.context.service(), (ToShapeId)operation);
            if (paginationInfoOptional.isPresent()) {
                PaginationInfo paginationInfo = (PaginationInfo)paginationInfoOptional.get();
                String operationName = this.symbolProvider.toSymbol((Shape)operation).getName();
                this.renderPaginator(writer, operationName, paginationInfo);
            }
        });
    }

    private void renderRbsPaginators(RubyCodeWriter writer) {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.model);
        PaginatedIndex paginatedIndex = PaginatedIndex.of((Model)this.model);
        topDownIndex.getContainedOperations((ToShapeId)this.context.service()).stream().forEach(operation -> {
            Optional paginationInfoOptional = paginatedIndex.getPaginationInfo((ToShapeId)this.context.service(), (ToShapeId)operation);
            if (paginationInfoOptional.isPresent()) {
                PaginationInfo paginationInfo = (PaginationInfo)paginationInfoOptional.get();
                String operationName = this.symbolProvider.toSymbol((Shape)operation).getName();
                this.renderRbsPaginator(writer, operationName, paginationInfo);
            }
        });
    }

    private void renderPaginator(RubyCodeWriter writer, String operationName, PaginationInfo paginationInfo) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.write("", new Object[0])).openBlock("class $L", new Object[]{operationName})).call(() -> this.renderPaginatorInitializeDocumentation(writer, operationName))).openBlock("def initialize(client, params = {}, options = {})", new Object[0])).write("@client = client", new Object[0])).write("@params = params", new Object[0])).write("@options = options", new Object[0])).closeBlock("end", new Object[0])).write("", new Object[0])).call(() -> this.renderPaginatorPages(writer, operationName, paginationInfo))).call(() -> {
            if (!paginationInfo.getItemsMemberPath().isEmpty()) {
                this.renderPaginatorItems(writer, paginationInfo, operationName);
            }
        })).closeBlock("end", new Object[0]);
    }

    private void renderRbsPaginator(RubyCodeWriter writer, String operationName, PaginationInfo paginationInfo) {
        String outputType = this.symbolProvider.toSymbol((Shape)paginationInfo.getOutput()).getName();
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.write("", new Object[0])).openBlock("class $L", new Object[]{operationName})).write("def initialize: (Client, ?::Hash[::Symbol, untyped] params, ?::Hash[::Symbol, untyped] options) -> void\n", new Object[0])).write("def pages: () -> ::Enumerator[Hearth::Output[Types::$L], void]", new Object[]{outputType})).call(() -> {
            List itemMembers = paginationInfo.getItemsMemberPath();
            if (!itemMembers.isEmpty()) {
                MemberShape last = (MemberShape)itemMembers.get(itemMembers.size() - 1);
                Shape shape = this.model.expectShape(last.getTarget());
                Object type = "untyped";
                if (shape.isMapShape()) {
                    String subType = this.symbolProvider.toSymbol(this.model.expectShape(((MapShape)shape).getValue().getTarget())).toString();
                    type = "Hash[::Symbol, " + subType + "]";
                } else if (shape.isListShape()) {
                    MemberShape member = (MemberShape)shape.members().stream().findFirst().get();
                    String subType = this.symbolProvider.toSymbol(this.model.expectShape(member.getTarget())).toString();
                    type = "Array[" + subType + "]";
                }
                writer.write("def items: () -> Enumerator[$L, void]", new Object[]{type});
            }
        })).closeBlock("end", new Object[0]);
    }

    private void renderPaginatorInitializeDocumentation(RubyCodeWriter writer, String operationName) {
        String snakeOperationName = RubyFormatter.toSnakeCase(operationName);
        writer.writeYardParam("Client", "client", "").writeYardReference("param", "Client#" + snakeOperationName);
    }

    private void renderPaginatorPages(RubyCodeWriter writer, String operationName, PaginationInfo paginationInfo) {
        String inputToken = this.symbolProvider.toMemberName(paginationInfo.getInputTokenMember());
        String outputToken = paginationInfo.getOutputTokenMemberPath().stream().map(member -> this.symbolProvider.toMemberName(member)).collect(Collectors.joining("&."));
        String snakeOperationName = RubyFormatter.toSnakeCase(operationName);
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.call(() -> this.renderPaginatorPagesDocumentation(writer, snakeOperationName))).openBlock("def pages", new Object[0])).write("params = @params", new Object[0])).openBlock("Enumerator.new do |e|", new Object[0])).write("@prev_token = params[:$L]", new Object[]{inputToken})).write("output = @client.$L(params, @options)", new Object[]{snakeOperationName})).write("e.yield(output)", new Object[0])).write("output_token = output.data.$L", new Object[]{outputToken})).write("", new Object[0])).openBlock("until output_token.nil? || @prev_token == output_token", new Object[0])).write("params = params.merge($L: output_token)", new Object[]{inputToken})).write("output = @client.$L(params, @options)", new Object[]{snakeOperationName})).write("e.yield(output)", new Object[0])).write("output_token = output.data.$L", new Object[]{outputToken})).closeBlock("end", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
    }

    private void renderPaginatorPagesDocumentation(RubyCodeWriter writer, String snakeOperationName) {
        writer.writeDocstring("Iterate all response pages of the " + snakeOperationName + " operation.").writeYardReturn("Enumerator", "");
    }

    private void renderPaginatorItems(RubyCodeWriter writer, PaginationInfo paginationInfo, String operationName) {
        String items = paginationInfo.getItemsMemberPath().stream().map(member -> this.symbolProvider.toMemberName(member)).collect(Collectors.joining("&."));
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.write("", new Object[0])).call(() -> this.renderPaginatorItemsDocumentation(writer, operationName))).openBlock("def items", new Object[0])).openBlock("Enumerator.new do |e|", new Object[0])).openBlock("pages.each do |page|", new Object[0])).openBlock("page.data.$L.each do |item|", new Object[]{items})).write("e.yield(item)", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
    }

    private void renderPaginatorItemsDocumentation(RubyCodeWriter writer, String operationName) {
        String snakeOperationName = RubyFormatter.toSnakeCase(operationName);
        writer.writeDocstring("Iterate all items from pages in the " + snakeOperationName + " operation.").writeYardReturn("Enumerator", "");
    }
}

