/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.HashSet;
import java.util.Set;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyDependency;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class GemspecGenerator {
    private final GenerationContext context;
    private final Set<RubyDependency> rubyDependencies;

    public GemspecGenerator(GenerationContext context) {
        this.context = context;
        this.rubyDependencies = context.getRubyDependencies();
    }

    public void render() {
        FileManifest fileManifest = this.context.fileManifest();
        RubySettings settings = this.context.settings();
        RubyCodeWriter writer = new RubyCodeWriter(this.context.settings().getModule());
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.preamble().openBlock("Gem::Specification.new do |spec|", new Object[0])).write("spec.name          = '$L'", new Object[]{settings.getGemName()})).write("spec.version       = File.read(File.expand_path('VERSION', __dir__)).strip", new Object[0])).write("spec.author        = 'Amazon Web Services'", new Object[0])).write("spec.summary       = '$L'", new Object[]{settings.getGemSummary()})).write("spec.files         = Dir['lib/**/*.rb', 'VERSION']", new Object[0])).write("", new Object[0])).call(() -> {
            HashSet indirectDependencies = new HashSet();
            this.rubyDependencies.forEach(rubyDependency -> indirectDependencies.addAll(rubyDependency.getRubyDependencies()));
            this.rubyDependencies.forEach(rubyDependency -> {
                if (rubyDependency.getType() != RubyDependency.Type.STANDARD_LIBRARY && !indirectDependencies.contains(rubyDependency)) {
                    writer.write("spec.add_runtime_dependency '$L', '$L'", new Object[]{rubyDependency.getGemName(), rubyDependency.getVersion()});
                }
            });
        })).closeBlock("end", new Object[0]);
        String fileName = settings.getGemName() + "/" + settings.getGemName() + ".gemspec";
        fileManifest.writeFile(fileName, writer.toString());
    }
}

