/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.build.SmithyBuildException;
import software.amazon.smithy.codegen.core.directed.ContextualDirective;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeVisitor;
import software.amazon.smithy.model.node.NullNode;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.generators.RubyGeneratorBase;
import software.amazon.smithy.ruby.codegen.rulesengine.AuthSchemeBinding;
import software.amazon.smithy.ruby.codegen.rulesengine.FunctionBinding;
import software.amazon.smithy.rulesengine.language.Endpoint;
import software.amazon.smithy.rulesengine.language.EndpointRuleSet;
import software.amazon.smithy.rulesengine.language.evaluation.value.Value;
import software.amazon.smithy.rulesengine.language.syntax.Identifier;
import software.amazon.smithy.rulesengine.language.syntax.expressions.Expression;
import software.amazon.smithy.rulesengine.language.syntax.expressions.ExpressionVisitor;
import software.amazon.smithy.rulesengine.language.syntax.expressions.Reference;
import software.amazon.smithy.rulesengine.language.syntax.expressions.Template;
import software.amazon.smithy.rulesengine.language.syntax.expressions.TemplateVisitor;
import software.amazon.smithy.rulesengine.language.syntax.expressions.functions.BooleanEquals;
import software.amazon.smithy.rulesengine.language.syntax.expressions.functions.FunctionDefinition;
import software.amazon.smithy.rulesengine.language.syntax.expressions.functions.GetAttr;
import software.amazon.smithy.rulesengine.language.syntax.expressions.functions.IsSet;
import software.amazon.smithy.rulesengine.language.syntax.expressions.functions.StringEquals;
import software.amazon.smithy.rulesengine.language.syntax.expressions.literal.Literal;
import software.amazon.smithy.rulesengine.language.syntax.expressions.literal.LiteralVisitor;
import software.amazon.smithy.rulesengine.language.syntax.parameters.Parameter;
import software.amazon.smithy.rulesengine.language.syntax.parameters.ParameterType;
import software.amazon.smithy.rulesengine.language.syntax.rule.Condition;
import software.amazon.smithy.rulesengine.language.syntax.rule.Rule;
import software.amazon.smithy.rulesengine.language.syntax.rule.RuleValueVisitor;
import software.amazon.smithy.rulesengine.traits.ClientContextParamsTrait;
import software.amazon.smithy.rulesengine.traits.ContextParamTrait;
import software.amazon.smithy.rulesengine.traits.EndpointTestCase;
import software.amazon.smithy.rulesengine.traits.EndpointTestOperationInput;
import software.amazon.smithy.rulesengine.traits.EndpointTestsTrait;
import software.amazon.smithy.rulesengine.traits.ExpectedEndpoint;
import software.amazon.smithy.rulesengine.traits.StaticContextParamDefinition;
import software.amazon.smithy.rulesengine.traits.StaticContextParamsTrait;
import software.amazon.smithy.utils.SmithyInternalApi;
import software.amazon.smithy.utils.StringUtils;

@SmithyInternalApi
public class EndpointGenerator
extends RubyGeneratorBase {
    public static final Identifier NAME = Identifier.of((String)"name");
    public static final String AUTH_SCHEMES = "authSchemes";
    private static final Logger LOGGER = Logger.getLogger(EndpointGenerator.class.getName());
    private final Set<OperationShape> operations;
    private final ServiceShape service;
    private final EndpointRuleSet endpointRuleSet;
    private final Optional<EndpointTestsTrait> endpointTests;

    public EndpointGenerator(ContextualDirective<GenerationContext, RubySettings> directive) {
        super(directive);
        this.operations = directive.operations();
        this.service = directive.service();
        this.endpointRuleSet = this.context.getEndpointRuleSet();
        this.endpointTests = this.service.getTrait(EndpointTestsTrait.class);
    }

    private void renderTestCaseExpected(RubyCodeWriter writer, EndpointTestCase testCase) {
        if (testCase.getExpect().getError().isPresent()) {
            writer.write("{error: $L}", new Object[]{StringUtils.escapeJavaString(testCase.getExpect().getError().get(), (String)"")});
        } else {
            ExpectedEndpoint expected = (ExpectedEndpoint)testCase.getExpect().getEndpoint().get();
            String expectedHeaders = "{" + expected.getHeaders().entrySet().stream().map(e -> "'" + (String)e.getKey() + "' => [" + ((List)e.getValue()).stream().map(h -> "'" + h + "'").collect(Collectors.joining(",")) + "]").collect(Collectors.joining(", ")) + "}";
            Object expectedAuthSchemes = "[]";
            Node authSchemes = (Node)expected.getProperties().get(AUTH_SCHEMES);
            if (authSchemes != null) {
                expectedAuthSchemes = "[" + authSchemes.expectArrayNode().getElementsAs(ObjectNode.class).stream().map(authScheme -> {
                    String name = ((StringNode)authScheme.getStringMember("name").get()).getValue();
                    if (!this.context.getAuthSchemeBinding(name).isPresent()) {
                        return null;
                    }
                    AuthSchemeBinding authSchemeBinding = this.context.getAuthSchemeBinding(name).get();
                    ObjectNode.Builder filteredProperties = ObjectNode.builder();
                    authScheme.getStringMap().forEach((k, v) -> {
                        if (authSchemeBinding.getAuthSchemeProperty((String)k).isPresent()) {
                            filteredProperties.withMember(authSchemeBinding.getAuthSchemeProperty((String)k).get(), (ToNode)v);
                        }
                    });
                    String propertiesHash = (String)filteredProperties.build().accept((NodeVisitor)new RubyNodeVisitor());
                    return "Hearth::EndpointRules::AuthScheme.new(scheme_id: '" + authSchemeBinding.getSchemeId() + "', properties: " + propertiesHash + ")";
                }).filter(Objects::nonNull).collect(Collectors.joining(", ")) + "]";
            }
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("{", new Object[0])).write("url: '$L',", new Object[]{expected.getUrl()})).write("headers: $L,", new Object[]{expectedHeaders})).write("auth_schemes: $L", new Object[]{expectedAuthSchemes})).closeBlock("}", new Object[0]);
        }
    }

    @Override
    String getModule() {
        return "Endpoint";
    }

    public void render() {
        List additionalFiles = Stream.concat(this.context.getBuiltInBindingsFromEndpointRules().stream().map(b -> b.writeAdditionalFiles(this.context)).flatMap(Collection::stream), this.context.getFunctionBindings().values().stream().map(b -> b.writeAdditionalFiles(this.context)).flatMap(Collection::stream)).distinct().sorted().collect(Collectors.toList());
        this.write(writer -> ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.preamble().includeRequires().writeRequireRelativeAdditionalFiles(additionalFiles).addModule(this.settings.getModule()).addModule("Endpoint").call(() -> this.renderEndpointParamsClass((RubyCodeWriter)((Object)writer)))).write("", new Object[0])).call(() -> this.renderEndpointResolver((RubyCodeWriter)((Object)writer)))).write("", new Object[0])).addModule("Parameters").call(() -> this.renderParamBuilders((RubyCodeWriter)((Object)writer)))).closeModule().write("", new Object[0])).closeAllModules());
        LOGGER.fine("Wrote endpoint to " + this.rbFile());
        if (this.endpointTests.isPresent()) {
            this.renderEndpointSpec();
        }
    }

    public void renderRbs() {
        this.writeRbs(writer -> ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.preamble().addModule(this.settings.getModule()).addModule("Endpoint").call(() -> this.renderRbsEndpointParamsClass((RubyCodeWriter)((Object)writer)))).write("", new Object[0])).call(() -> this.renderRbsEndpointResolver((RubyCodeWriter)((Object)writer)))).closeAllModules());
        LOGGER.fine("Wrote endpoint rbs to " + this.rbsFile());
    }

    private void renderEndpointParamsClass(RubyCodeWriter writer) {
        ArrayList params = new ArrayList();
        LinkedHashMap defaultParams = new LinkedHashMap();
        this.endpointRuleSet.getParameters().forEach(parameter -> {
            String rubyParamName = RubyFormatter.toSnakeCase(parameter.getName().getName().getValue());
            params.add(RubyFormatter.asSymbol(rubyParamName));
            if (parameter.getDefault().isPresent()) {
                if (parameter.getType() == ParameterType.STRING) {
                    defaultParams.put(rubyParamName, "'" + ((Value)parameter.getDefault().get()).expectStringValue().getValue() + "'");
                } else if (parameter.getType() == ParameterType.BOOLEAN) {
                    defaultParams.put(rubyParamName, ((Value)parameter.getDefault().get()).expectBooleanValue().getValue() ? "true" : "false");
                } else {
                    throw new IllegalArgumentException("Unexpected parameter type: " + parameter.getType());
                }
            }
        });
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("Params = ::Struct.new(", new Object[0])).write(String.join((CharSequence)",\n", params) + ", ", new Object[0])).write("keyword_init: true", new Object[0])).closeBlock(") do", new Object[0])).indent()).write("include $T", new Object[]{Hearth.STRUCTURE})).call(() -> {
            if (!defaultParams.isEmpty()) {
                ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.write("", new Object[0])).openBlock("def initialize(*)", new Object[0])).write("super", new Object[0])).call(() -> defaultParams.forEach((param, defaultValue) -> writer.write("self.$1L = $2L if self.$1L.nil?", new Object[]{param, defaultValue})))).closeBlock("end", new Object[0]);
            }
        })).closeBlock("end", new Object[0]);
    }

    private void renderRbsEndpointParamsClass(RubyCodeWriter writer) {
        HashMap paramsToTypes = new HashMap();
        this.endpointRuleSet.getParameters().forEach(parameter -> {
            String rubyParamName = RubyFormatter.toSnakeCase(parameter.getName().getName().getValue());
            if (parameter.getType() == ParameterType.STRING) {
                paramsToTypes.put(rubyParamName, "::String");
            } else if (parameter.getType() == ParameterType.BOOLEAN) {
                paramsToTypes.put(rubyParamName, "bool");
            } else {
                throw new IllegalArgumentException("Unexpected parameter type: " + parameter.getType());
            }
        });
        ((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("class Params < ::Struct[untyped]", new Object[0])).call(() -> paramsToTypes.forEach((param, rbsType) -> writer.write("attr_accessor $L: $L", new Object[]{param, rbsType})))).closeBlock("end", new Object[0]);
    }

    private void renderParamBuilders(RubyCodeWriter writer) {
        HashMap clientContextParams = new HashMap();
        this.service.getTrait(ClientContextParamsTrait.class).ifPresent(clientContext -> clientContext.getParameters().forEach((name, param) -> clientContextParams.put(name, RubyFormatter.toSnakeCase(name))));
        for (OperationShape operation : this.operations) {
            HashMap staticContextParams = new HashMap();
            operation.getTrait(StaticContextParamsTrait.class).ifPresent(staticContext -> staticContext.getParameters().forEach((name, p) -> staticContextParams.put(name, p)));
            HashMap contextParams = new HashMap();
            ((StructureShape)this.context.model().expectShape(operation.getInputShape(), StructureShape.class)).getAllMembers().forEach((n, member) -> member.getMemberTrait(this.context.model(), ContextParamTrait.class).ifPresent(contextParam -> contextParams.put(contextParam.getName(), this.symbolProvider.toMemberName(member))));
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.write("", new Object[0])).openBlock("class $L", new Object[]{this.symbolProvider.toSymbol((Shape)operation).getName()})).openBlock("def self.build(config, input, context)", new Object[0])).write("params = Params.new", new Object[0])).call(() -> {
                for (Parameter p : this.endpointRuleSet.getParameters()) {
                    String paramName = p.getName().toString();
                    if (p.isBuiltIn()) {
                        this.context.getBuiltInBinding((String)p.getBuiltIn().get()).get().renderBuild(writer, this.context, operation);
                        continue;
                    }
                    if (staticContextParams.containsKey(paramName)) {
                        Object value;
                        StaticContextParamDefinition def = (StaticContextParamDefinition)staticContextParams.get(paramName);
                        if (def.getValue().isStringNode()) {
                            value = "'" + def.getValue().expectStringNode() + "'";
                        } else if (def.getValue().isBooleanNode()) {
                            value = def.getValue().expectBooleanNode().getValue() ? "true" : "false";
                        } else {
                            throw new SmithyBuildException("Unexpected StaticContextParam type: " + def.getValue().getType() + " for parameter: " + paramName);
                        }
                        writer.write("params.$L = $L", new Object[]{RubyFormatter.toSnakeCase(paramName), value});
                        continue;
                    }
                    if (clientContextParams.containsKey(paramName)) {
                        writer.write("params.$1L = config[:$1L] unless config[:$1L].nil?", new Object[]{clientContextParams.get(paramName)});
                        continue;
                    }
                    if (!contextParams.containsKey(paramName)) continue;
                    writer.write("params.$1L = input.$2L unless input.$2L.nil?", new Object[]{RubyFormatter.toSnakeCase(paramName), contextParams.get(paramName)});
                }
            })).write("params", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
        }
    }

    private void renderEndpointResolver(RubyCodeWriter writer) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("class Resolver", new Object[0])).openBlock("def resolve(params)", new Object[0])).call(() -> this.mapParametersToLocals(writer))).write("", new Object[0])).call(() -> this.renderRules(writer, this.endpointRuleSet.getRules()))).write("", new Object[0])).call(() -> {
            List rules = this.endpointRuleSet.getRules();
            if (rules.isEmpty() || !((Rule)rules.get(rules.size() - 1)).getConditions().isEmpty()) {
                writer.write("raise ArgumentError, 'No endpoint could be resolved'", new Object[0]);
            }
        })).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]);
    }

    private void renderRbsEndpointResolver(RubyCodeWriter writer) {
        ((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("class Resolver", new Object[0])).write("def resolve: (Params params) -> Hearth::EndpointRules::Endpoint", new Object[0])).closeBlock("end", new Object[0]);
    }

    private void renderEndpointSpec() {
        RubyCodeWriter specWriter = new RubyCodeWriter(this.context.settings().getModule());
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)specWriter.preamble().write("require_relative 'spec_helper'", new Object[0])).write("", new Object[0])).addModule(this.settings.getModule()).addModule("Endpoint").openBlock("describe Resolver do", new Object[0])).write("subject { Resolver.new }", new Object[0])).call(() -> this.renderEndpointTestCases(specWriter, this.endpointTests.get().getTestCases()))).closeBlock("end", new Object[0])).closeAllModules();
        String endpointSpecFile = this.settings.getGemName() + "/spec/endpoint_spec.rb";
        this.context.fileManifest().writeFile(endpointSpecFile, specWriter.toString());
        LOGGER.fine("Wrote endpoint tests to " + endpointSpecFile);
    }

    private void renderRules(RubyCodeWriter writer, List<Rule> rules) {
        for (Rule rule : rules) {
            if (rule.getDocumentation().isPresent()) {
                writer.write("# $L", new Object[]{rule.getDocumentation().get()});
            }
            if (!rule.getConditions().isEmpty()) {
                ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.call(() -> this.renderConditions(writer, rule.getConditions()))).indent()).call(() -> this.renderRule(writer, rule))).closeBlock("end", new Object[0]);
                continue;
            }
            this.renderRule(writer, rule);
        }
    }

    private void renderRule(RubyCodeWriter writer, Rule rule) {
        rule.accept((RuleValueVisitor)new RubyRuleVisitor(writer));
    }

    private void renderConditions(RubyCodeWriter writer, List<Condition> conditions) {
        String condition = conditions.stream().map(c -> {
            if (c.getResult().isPresent()) {
                return "(" + RubyFormatter.toSnakeCase(((Identifier)c.getResult().get()).getName().getValue()) + " = " + (String)c.getFunction().accept((ExpressionVisitor)new RubyExpressionVisitor(this.context)) + ")";
            }
            return (String)c.getFunction().accept((ExpressionVisitor)new RubyExpressionVisitor(this.context));
        }).collect(Collectors.joining(" && "));
        writer.write("if $L", new Object[]{condition});
    }

    private void mapParametersToLocals(RubyCodeWriter writer) {
        for (Parameter parameter : this.endpointRuleSet.getParameters()) {
            writer.write("$1L = params.$1L", new Object[]{RubyFormatter.toSnakeCase(parameter.getName().toString())});
        }
    }

    private String templateExpression(Expression expression) {
        return (String)expression.accept((ExpressionVisitor)new RubyExpressionVisitor(this.context));
    }

    private void renderEndpointTestCases(RubyCodeWriter writer, List<EndpointTestCase> testCases) {
        for (EndpointTestCase testCase : testCases) {
            String paramArgs = testCase.getParams().getMembers().entrySet().stream().map(e -> {
                String value = ((Node)e.getValue()).isStringNode() ? StringUtils.escapeJavaString((Object)((Node)e.getValue()).expectStringNode().getValue(), (String)"") : (((Node)e.getValue()).expectBooleanNode().getValue() ? "true" : "false");
                return RubyFormatter.toSnakeCase(((StringNode)e.getKey()).getValue()) + ": " + value;
            }).collect(Collectors.joining(", "));
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.write("", new Object[0])).openBlock("context $S do", new Object[]{testCase.getDocumentation().orElse("Test case " + testCase.hashCode())})).openBlock("let(:expected) do", new Object[0])).call(() -> this.renderTestCaseExpected(writer, testCase))).closeBlock("end", new Object[0])).write("", new Object[0])).openBlock("it 'produces the expected output from the EndpointResolver' do", new Object[0])).write("params = Params.new($L)", new Object[]{paramArgs})).call(() -> {
                if (testCase.getExpect().getError().isPresent()) {
                    ((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("expect do", new Object[0])).write("subject.resolve(params)", new Object[0])).closeBlock("end.to raise_error(ArgumentError, expected[:error])", new Object[0]);
                } else {
                    ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.write("endpoint = subject.resolve(params)", new Object[0])).write("expect(endpoint.uri).to eq(expected[:url])", new Object[0])).write("expect(endpoint.headers).to eq(expected[:headers])", new Object[0])).write("expect(endpoint.auth_schemes).to eq(expected[:auth_schemes])", new Object[0]);
                }
            })).closeBlock("end", new Object[0])).call(() -> {
                for (EndpointTestOperationInput operationInput : testCase.getOperationInputs()) {
                    this.renderOperationInputTest(writer, testCase, operationInput);
                }
            })).closeBlock("end", new Object[0]);
        }
    }

    private void renderOperationInputTest(RubyCodeWriter writer, EndpointTestCase testCase, EndpointTestOperationInput operationInput) {
        ShapeId operationId = this.service.getOperations().stream().filter(id -> id.getName().contains(operationInput.getOperationName())).findFirst().get();
        OperationShape operation = (OperationShape)this.model.expectShape(operationId, OperationShape.class);
        String operationName = RubyFormatter.toSnakeCase(this.symbolProvider.toSymbol((Shape)operation).getName());
        String configParams = operationInput.getClientParams().getMembers().entrySet().stream().map(e -> RubyFormatter.toSnakeCase(((StringNode)e.getKey()).getValue()) + ": " + (String)((Node)e.getValue()).accept((NodeVisitor)new RubyNodeVisitor())).collect(Collectors.joining(", "));
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.write("", new Object[0])).openBlock("it 'produces the correct output from the client when calling $L' do", new Object[]{operationName})).write("config = {$L}", new Object[]{configParams})).write("config[:stub_responses] = true", new Object[0])).write("config[:endpoint] = nil", new Object[0])).call(() -> operationInput.getBuiltInParams().getMembers().forEach((builtIn, value) -> this.context.getBuiltInBinding(builtIn.getValue()).get().renderTestSet(writer, this.context, (Node)value, operation)))).write("", new Object[0])).write("client = Client.new(config)", new Object[0]);
        String operationInputs = operationInput.getOperationParams().getMembers().entrySet().stream().map(e -> RubyFormatter.toSnakeCase(((StringNode)e.getKey()).getValue()) + ": " + (String)((Node)e.getValue()).accept((NodeVisitor)new RubyNodeVisitor())).collect(Collectors.joining(", "));
        if (testCase.getExpect().getError().isPresent()) {
            ((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("expect do", new Object[0])).write("client.$L($L)", new Object[]{operationName, operationInputs})).closeBlock("end.to raise_error(ArgumentError, '$L')", new Object[]{testCase.getExpect().getError().get()});
        } else {
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("proc = proc do |context|", new Object[0])).write("expected_uri = URI.parse(expected[:url])", new Object[0])).write("request_uri = context.request.uri", new Object[0])).write("expect(request_uri.hostname).to end_with(expected_uri.hostname)", new Object[0])).write("expect(request_uri.scheme).to eq(expected_uri.scheme)", new Object[0])).write("expect(request_uri.path).to start_with(expected_uri.path)", new Object[0])).openBlock("expected[:headers].each do |k,v|", new Object[0])).write("expect(context.request.headers[k]).to eq(Hearth::HTTP::Field.new(k, v).value)", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0])).write("interceptor = Hearth::Interceptor.new(read_before_transmit: proc)", new Object[0])).write("client.$L({$L}, interceptors: [interceptor])", new Object[]{operationName, operationInputs});
        }
        writer.closeBlock("end", new Object[0]);
    }

    private class RubyRuleVisitor
    implements RuleValueVisitor<Void> {
        final RubyCodeWriter writer;

        RubyRuleVisitor(RubyCodeWriter writer) {
            this.writer = writer;
        }

        public Void visitTreeRule(List<Rule> list) {
            EndpointGenerator.this.renderRules(this.writer, list);
            return null;
        }

        public Void visitErrorRule(Expression expression) {
            this.writer.write("raise ArgumentError, $L", new Object[]{expression.accept((ExpressionVisitor)new RubyExpressionVisitor(EndpointGenerator.this.context))});
            return null;
        }

        public Void visitEndpointRule(Endpoint endpoint) {
            String uriString = EndpointGenerator.this.templateExpression(endpoint.getUrl());
            RubyExpressionVisitor expressionVisitor = new RubyExpressionVisitor(EndpointGenerator.this.context);
            if (endpoint.getHeaders().isEmpty() && endpoint.getProperties().isEmpty()) {
                this.writer.write("return $T.new(uri: $L)", new Object[]{Hearth.RULES_ENGINE_ENDPOINT, uriString});
            } else {
                Object authSchemesString;
                String headersString = "{" + endpoint.getHeaders().entrySet().stream().map(e -> "'" + (String)e.getKey() + "' => [" + ((List)e.getValue()).stream().map(expression -> (String)expression.accept(expressionVisitor)).collect(Collectors.joining(", ")) + "]").collect(Collectors.joining(", ")) + "}";
                Literal authSchemes = (Literal)endpoint.getProperties().get(Identifier.of((String)EndpointGenerator.AUTH_SCHEMES));
                if (authSchemes != null) {
                    List authSchemesList = (List)authSchemes.asTupleLiteral().get();
                    authSchemesString = "[" + authSchemesList.stream().map(l -> {
                        Map authSchemeMap = (Map)l.asRecordLiteral().get();
                        String name = (String)((Literal)authSchemeMap.get(NAME)).accept(expressionVisitor);
                        Optional<AuthSchemeBinding> maybeAuthScheme = EndpointGenerator.this.context.getAuthSchemeBinding(name.replace("\"", ""));
                        if (!maybeAuthScheme.isPresent()) {
                            return null;
                        }
                        AuthSchemeBinding authSchemeBinding = maybeAuthScheme.get();
                        String propertiesHash = "{" + authSchemeMap.entrySet().stream().filter(e -> {
                            String key = ((Identifier)e.getKey()).getName().getValue();
                            return !((Identifier)e.getKey()).equals((Object)NAME) && authSchemeBinding.getAuthSchemeProperty(key).isPresent();
                        }).map(e -> {
                            String key = ((Identifier)e.getKey()).getName().getValue();
                            return "'" + authSchemeBinding.getAuthSchemeProperty(key).get() + "' => " + (String)((Literal)e.getValue()).accept(expressionVisitor);
                        }).collect(Collectors.joining(", ")) + "}";
                        return "Hearth::EndpointRules::AuthScheme.new(scheme_id: " + StringUtils.escapeJavaString((Object)authSchemeBinding.getSchemeId(), (String)"") + ", properties: " + propertiesHash + ")";
                    }).filter(Objects::nonNull).collect(Collectors.joining(", ")) + "]";
                } else {
                    authSchemesString = "[]";
                }
                ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("return $T.new(", new Object[]{Hearth.RULES_ENGINE_ENDPOINT})).write("uri: $L,", new Object[]{uriString})).write("headers: $L,", new Object[]{headersString})).write("auth_schemes: $L", new Object[]{authSchemesString})).closeBlock(")", new Object[0]);
            }
            return null;
        }
    }

    private static class RubyExpressionVisitor
    implements ExpressionVisitor<String> {
        final GenerationContext context;

        RubyExpressionVisitor(GenerationContext context) {
            this.context = context;
        }

        public String visitLiteral(Literal literal) {
            return (String)literal.accept((LiteralVisitor)new TemplateLiteralVisitor(this.context));
        }

        public String visitRef(Reference reference) {
            return RubyFormatter.toSnakeCase(reference.getName().getName().getValue());
        }

        public String visitGetAttr(GetAttr getAttr) {
            return (String)getAttr.getTarget().accept((ExpressionVisitor)this) + getAttr.getPath().stream().map(p -> {
                if (p instanceof GetAttr.Part.Index) {
                    return "[" + ((GetAttr.Part.Index)p).index() + "]";
                }
                if (p instanceof GetAttr.Part.Key) {
                    return "['" + ((GetAttr.Part.Key)p).key() + "']";
                }
                throw new SmithyBuildException("Unknown getAttr Part type: " + p.getClass().getName());
            }).collect(Collectors.joining());
        }

        public String visitIsSet(Expression expression) {
            return (String)expression.accept((ExpressionVisitor)this) + " != nil";
        }

        public String visitNot(Expression expression) {
            if (expression.getClass().equals(StringEquals.class)) {
                StringEquals eq = (StringEquals)expression;
                return (String)((Expression)eq.getArguments().get(0)).accept((ExpressionVisitor)this) + " != " + (String)((Expression)eq.getArguments().get(1)).accept((ExpressionVisitor)this);
            }
            if (expression.getClass().equals(BooleanEquals.class)) {
                BooleanEquals eq = (BooleanEquals)expression;
                return (String)((Expression)eq.getArguments().get(0)).accept((ExpressionVisitor)this) + " != " + (String)((Expression)eq.getArguments().get(1)).accept((ExpressionVisitor)this);
            }
            if (expression.getClass().equals(IsSet.class)) {
                IsSet isSet = (IsSet)expression;
                return (String)((Expression)isSet.getArguments().get(0)).accept((ExpressionVisitor)this) + ".nil?";
            }
            return "!" + (String)expression.accept((ExpressionVisitor)this);
        }

        public String visitBoolEquals(Expression expression1, Expression expression2) {
            return (String)expression1.accept((ExpressionVisitor)this) + " == " + (String)expression2.accept((ExpressionVisitor)this);
        }

        public String visitStringEquals(Expression expression1, Expression expression2) {
            return (String)expression1.accept((ExpressionVisitor)this) + " == " + (String)expression2.accept((ExpressionVisitor)this);
        }

        public String visitLibraryFunction(FunctionDefinition functionDefinition, List<Expression> args) {
            FunctionBinding functionBinding = this.context.getFunctionBinding(functionDefinition.getId()).orElseThrow(() -> new SmithyBuildException("Unable to find rules engine function binding for: " + functionDefinition.getId()));
            String rubyArgs = args.stream().map(e -> (String)e.accept((ExpressionVisitor)new RubyExpressionVisitor(this.context))).collect(Collectors.joining(", "));
            return functionBinding.getRubyMethodName() + "(" + rubyArgs + ")";
        }
    }

    private static class RubyNodeVisitor
    implements NodeVisitor<String> {
        private RubyNodeVisitor() {
        }

        public String arrayNode(ArrayNode node) {
            return "[" + node.getElements().stream().map(n -> (String)n.accept((NodeVisitor)this)).collect(Collectors.joining(", ")) + "]";
        }

        public String booleanNode(BooleanNode node) {
            return node.getValue() ? "true" : "false";
        }

        public String nullNode(NullNode node) {
            return "nil";
        }

        public String numberNode(NumberNode node) {
            return node.getValue().toString();
        }

        public String objectNode(ObjectNode node) {
            return "{" + node.getMembers().entrySet().stream().map(e -> (String)((StringNode)e.getKey()).accept((NodeVisitor)this) + " => " + (String)((Node)e.getValue()).accept((NodeVisitor)this)).collect(Collectors.joining(", ")) + "}";
        }

        public String stringNode(StringNode node) {
            return "'" + node.getValue() + "'";
        }
    }

    private static class RubyTemplateVisitor
    implements TemplateVisitor<String> {
        final GenerationContext context;

        RubyTemplateVisitor(GenerationContext context) {
            this.context = context;
        }

        public String visitStaticTemplate(String s) {
            return StringUtils.escapeJavaString((Object)s, (String)"");
        }

        public String visitSingleDynamicTemplate(Expression expression) {
            return (String)expression.accept((ExpressionVisitor)new RubyExpressionVisitor(this.context));
        }

        public String visitStaticElement(String s) {
            String escaped = StringUtils.escapeJavaString((Object)s, (String)"");
            return escaped.substring(1, escaped.length() - 1);
        }

        public String visitDynamicElement(Expression expression) {
            return "#{" + (String)expression.accept((ExpressionVisitor)new RubyExpressionVisitor(this.context)) + "}";
        }

        public String startMultipartTemplate() {
            return "\"";
        }

        public String finishMultipartTemplate() {
            return "\"";
        }
    }

    private static class TemplateLiteralVisitor
    implements LiteralVisitor<String> {
        final GenerationContext context;

        TemplateLiteralVisitor(GenerationContext context) {
            this.context = context;
        }

        public String visitBoolean(boolean b) {
            return b ? "true" : "false";
        }

        public String visitString(Template template) {
            return template.accept((TemplateVisitor)new RubyTemplateVisitor(this.context)).collect(Collectors.joining());
        }

        public String visitRecord(Map<Identifier, Literal> map) {
            StringBuilder ret = new StringBuilder();
            ret.append("{");
            ret.append(map.entrySet().stream().map(e -> ((Identifier)e.getKey()).getName().getValue() + "=>" + (String)((Literal)e.getValue()).accept((LiteralVisitor)this)).collect(Collectors.joining(", ")));
            ret.append("}");
            return ret.toString();
        }

        public String visitTuple(List<Literal> list) {
            String ret = "[" + list.stream().map(l -> (String)l.accept((LiteralVisitor)this)).collect(Collectors.joining(", ")) + "]";
            return ret;
        }

        public String visitInteger(int i) {
            return Integer.toString(i);
        }
    }
}

