/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.directed.ContextualDirective;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.RubySymbolProvider;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;
import software.amazon.smithy.ruby.codegen.generators.RubyGeneratorBase;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class ConfigGenerator
extends RubyGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger(ConfigGenerator.class.getName());
    private final List<ClientConfig> clientConfigList;

    public ConfigGenerator(ContextualDirective<GenerationContext, RubySettings> directive, List<ClientConfig> clientConfigList) {
        super(directive);
        this.clientConfigList = clientConfigList;
    }

    @Override
    String getModule() {
        return "Config";
    }

    public void render() {
        this.write(writer -> {
            Object membersBlock = "nil";
            if (!this.clientConfigList.isEmpty()) {
                membersBlock = this.clientConfigList.stream().map(clientConfig -> RubyFormatter.asSymbol(RubySymbolProvider.toMemberName(clientConfig.getName()))).collect(Collectors.joining(",\n"));
            }
            membersBlock = (String)membersBlock + ",";
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.preamble().includeRequires().openBlock("module $L", new Object[]{this.settings.getModule()})).call(() -> this.renderConfigDocumentation((RubyCodeWriter)((Object)writer)))).openBlock("Config = ::Struct.new(", new Object[0])).write(membersBlock, new Object[0])).write("keyword_init: true", new Object[0])).closeBlock(") do", new Object[0])).indent()).write("include $T", new Object[]{Hearth.CONFIGURATION})).write("", new Object[0])).call(() -> this.renderValidateMethod((RubyCodeWriter)((Object)writer)))).write("\nprivate\n", new Object[0])).call(() -> this.renderDefaultsMethod((RubyCodeWriter)((Object)writer)))).closeBlock("end", new Object[0])).closeBlock("end\n", new Object[0]);
        });
        LOGGER.fine("Wrote config to " + this.rbFile());
    }

    public void renderRbs() {
        this.writeRbs(writer -> ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("module $L", new Object[]{this.settings.getModule()})).openBlock("class Config < ::Struct[untyped]", new Object[0])).write("include $T[instance]", new Object[]{Hearth.CONFIGURATION})).write("", new Object[0])).call(() -> this.clientConfigList.forEach(clientConfig -> {
            String member = RubySymbolProvider.toMemberName(clientConfig.getName());
            String rbsType = clientConfig.getRbsType();
            writer.write("attr_accessor $L (): $L", new Object[]{member, rbsType});
        }))).write("", new Object[0])).write("def validate!: () -> void", new Object[0])).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]));
        LOGGER.fine("Wrote config rbs to " + this.rbsFile());
    }

    private void renderConfigDocumentation(RubyCodeWriter writer) {
        writer.writeYardMethod("initialize(*options)", () -> this.clientConfigList.forEach(clientConfig -> {
            String member = RubyFormatter.asSymbol(RubySymbolProvider.toMemberName(clientConfig.getName()));
            String returnType = clientConfig.getDocumentationType();
            String defaultValue = clientConfig.getDocumentationDefaultValue();
            String documentation = clientConfig.getDocumentation();
            writer.writeYardOption("args", returnType, member, defaultValue, documentation);
        }));
        this.clientConfigList.forEach(clientConfig -> {
            String member = RubySymbolProvider.toMemberName(clientConfig.getName());
            writer.writeYardAttribute(member, () -> writer.writeYardReturn(clientConfig.getDocumentationType(), ""));
        });
    }

    private void renderValidateMethod(RubyCodeWriter writer) {
        writer.writeDocstring("Validates the configuration.").openBlock("def validate!", new Object[0]);
        this.clientConfigList.forEach(clientConfig -> {
            String member = RubySymbolProvider.toMemberName(clientConfig.getName());
            clientConfig.getConstraints().forEach(c -> writer.write(c.render(member), new Object[0]));
        });
        writer.closeBlock("end", new Object[0]);
    }

    private void renderDefaultsMethod(RubyCodeWriter writer) {
        ((RubyCodeWriter)writer.openBlock("def defaults", new Object[0])).openBlock("{", new Object[0]);
        this.clientConfigList.forEach(clientConfig -> writer.write("$L: $L,", new Object[]{clientConfig.getName(), clientConfig.renderDefaults(this.context)}));
        ((RubyCodeWriter)((RubyCodeWriter)writer.unwrite(",\n", new Object[0])).closeBlock("\n}.freeze", new Object[0])).closeBlock("end", new Object[0]);
    }
}

