/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.auth.factories;

import java.util.HashMap;
import software.amazon.smithy.model.traits.HttpApiKeyAuthTrait;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.auth.AuthScheme;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;

public final class HttpApiKeyAuthSchemeFactory {
    private HttpApiKeyAuthSchemeFactory() {
    }

    public static AuthScheme build() {
        String identityProviderDocumentation = "A %s that returns a %s for operations modeled with the %s auth scheme.\n";
        String defaultIdentity = Hearth.IDENTITIES + "::HTTPApiKey.new(key: 'stubbed api key')";
        String defaultConfigValue = "cfg[:stub_responses] ? %s.new(proc { %s }) : nil".formatted(Hearth.IDENTITY_PROVIDER, defaultIdentity);
        String identityType = Hearth.IDENTITIES + "::HTTPApiKey";
        ClientConfig identityProviderConfig = ClientConfig.builder().name("http_api_key_provider").documentation(identityProviderDocumentation.formatted(Hearth.IDENTITY_PROVIDER, identityType, HttpApiKeyAuthTrait.ID)).documentationRbsAndValidationType(Hearth.IDENTITY_PROVIDER.toString()).defaultDynamicValue(defaultConfigValue).build();
        return AuthScheme.builder().shapeId(HttpApiKeyAuthTrait.ID).rubyAuthScheme(Hearth.AUTH_SCHEMES + "::HTTPApiKey.new").rubyIdentityType(identityType).identityProviderConfig(identityProviderConfig).extractSignerProperties(trait -> {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("in", "'%s'".formatted(((HttpApiKeyAuthTrait)trait).getIn().toString()));
            properties.put("name", "'%s'".formatted(((HttpApiKeyAuthTrait)trait).getName()));
            if (((HttpApiKeyAuthTrait)trait).getScheme().isPresent()) {
                properties.put("scheme", "'%s'".formatted(((HttpApiKeyAuthTrait)trait).getScheme().get()));
            }
            return properties;
        }).build();
    }
}

