/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.ruby.codegen.RubyDependency;
import software.amazon.smithy.ruby.codegen.UnresolvableProtocolException;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class RubySettings {
    private static final Logger LOGGER = Logger.getLogger(RubySettings.class.getName());
    private static final String SERVICE = "service";
    private static final String MODULE = "module";
    private static final String GEMSPEC = "gemspec";
    private static final String GEM_NAME = "gemName";
    private static final String GEM_VERSION = "gemVersion";
    private static final String GEM_SUMMARY = "gemSummary";
    private ShapeId service;
    private String module;
    private String gemName;
    private String gemVersion;
    private String gemSummary;

    public static RubySettings from(ObjectNode config) {
        RubySettings settings = new RubySettings();
        config.warnIfAdditionalProperties(Arrays.asList(SERVICE, MODULE, GEMSPEC, GEM_NAME, GEM_VERSION, GEM_SUMMARY));
        settings.setService(config.expectStringMember(SERVICE).expectShapeId());
        settings.setModule(config.expectStringMember(MODULE).getValue());
        ObjectNode gemspec = config.expectObjectMember(GEMSPEC);
        settings.setGemName(gemspec.expectStringMember(GEM_NAME).getValue());
        settings.setGemVersion(gemspec.expectStringMember(GEM_VERSION).getValue());
        settings.setGemSummary(gemspec.expectStringMember(GEM_SUMMARY).getValue());
        LOGGER.info("Created Ruby Settings: " + settings);
        return settings;
    }

    public ShapeId getService() {
        return this.service;
    }

    public void setService(ShapeId service) {
        this.service = service;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getGemName() {
        return this.gemName;
    }

    public void setGemName(String gemName) {
        this.gemName = gemName;
    }

    public String getGemVersion() {
        return this.gemVersion;
    }

    public void setGemVersion(String gemVersion) {
        this.gemVersion = gemVersion;
    }

    public String getGemSummary() {
        return this.gemSummary;
    }

    public void setGemSummary(String gemSummary) {
        this.gemSummary = gemSummary;
    }

    public Set<RubyDependency> getBaseDependencies() {
        return Set.of(RubyDependency.HEARTH);
    }

    public ShapeId resolveServiceProtocol(ServiceShape service, Model model, Set<ShapeId> supportedProtocolTraits) {
        Map resolvedProtocols = ServiceIndex.of((Model)model).getProtocols((ToShapeId)service);
        for (ShapeId p2 : resolvedProtocols.keySet()) {
            LOGGER.info("Found service protocol: " + p2.getName() + " -> " + p2);
        }
        ShapeId protocol = resolvedProtocols.keySet().stream().filter(p -> supportedProtocolTraits.contains(p)).findFirst().orElseThrow(() -> new UnresolvableProtocolException("No protocol generators were found "));
        LOGGER.info("Resolved protocol: " + protocol.getName());
        return protocol;
    }
}

