/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.build.SmithyBuildException;
import software.amazon.smithy.codegen.core.CodegenContext;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.codegen.core.SymbolWriter;
import software.amazon.smithy.codegen.core.WriterDelegator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.ruby.codegen.ApplicationTransport;
import software.amazon.smithy.ruby.codegen.ProtocolGenerator;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyDependency;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubyIntegration;
import software.amazon.smithy.ruby.codegen.RubyRuntimePlugin;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.auth.AuthParam;
import software.amazon.smithy.ruby.codegen.auth.AuthScheme;
import software.amazon.smithy.ruby.codegen.auth.factories.AnonymousAuthSchemeFactory;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;
import software.amazon.smithy.ruby.codegen.rulesengine.AuthSchemeBinding;
import software.amazon.smithy.ruby.codegen.rulesengine.BuiltInBinding;
import software.amazon.smithy.ruby.codegen.rulesengine.FunctionBinding;
import software.amazon.smithy.rulesengine.language.Endpoint;
import software.amazon.smithy.rulesengine.language.EndpointRuleSet;
import software.amazon.smithy.rulesengine.language.syntax.ToCondition;
import software.amazon.smithy.rulesengine.language.syntax.parameters.BuiltIns;
import software.amazon.smithy.rulesengine.language.syntax.parameters.Parameters;
import software.amazon.smithy.rulesengine.language.syntax.rule.EndpointRule;
import software.amazon.smithy.rulesengine.traits.ClientContextParamDefinition;
import software.amazon.smithy.rulesengine.traits.ClientContextParamsTrait;
import software.amazon.smithy.rulesengine.traits.EndpointRuleSetTrait;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public class GenerationContext
implements CodegenContext<RubySettings, RubyCodeWriter, RubyIntegration> {
    private final RubySettings rubySettings;
    private final FileManifest fileManifest;
    private final List<RubyIntegration> integrations;
    private final Model model;
    private final ServiceShape service;
    private final ShapeId protocol;
    private final Optional<ProtocolGenerator> protocolGenerator;
    private final ApplicationTransport applicationTransport;
    private final SymbolProvider symbolProvider;
    private final WriterDelegator<RubyCodeWriter> writerDelegator;
    private final Map<String, BuiltInBinding> rulesEngineBuiltIns;
    private final Map<String, FunctionBinding> rulesEngineFunctions;
    private final Map<String, AuthSchemeBinding> rulesEngineAuthSchemes;
    private final Set<AuthScheme> serviceAuthSchemes;
    private final Set<AuthParam> authParams;
    private final List<ClientConfig> modeledClientConfig;
    private final EndpointRuleSet endpointRuleSet;

    public GenerationContext(RubySettings rubySettings, FileManifest fileManifest, List<RubyIntegration> integrations, Model model, ServiceShape service, ShapeId protocol, Optional<ProtocolGenerator> protocolGenerator, ApplicationTransport applicationTransport, SymbolProvider symbolProvider, List<BuiltInBinding> rulesEngineBuiltIns, List<FunctionBinding> rulesEngineFunctions, List<AuthSchemeBinding> rulesEngineAuthSchemes) {
        this.rubySettings = rubySettings;
        this.fileManifest = fileManifest;
        this.integrations = integrations;
        this.model = model;
        this.service = service;
        this.protocol = protocol;
        this.protocolGenerator = protocolGenerator;
        this.applicationTransport = applicationTransport;
        this.symbolProvider = symbolProvider;
        this.rulesEngineBuiltIns = rulesEngineBuiltIns.stream().collect(Collectors.toMap(b -> (String)b.getBuiltIn().getBuiltIn().get(), b -> b));
        this.rulesEngineFunctions = rulesEngineFunctions.stream().collect(Collectors.toMap(b -> b.getId(), b -> b));
        this.rulesEngineAuthSchemes = rulesEngineAuthSchemes.stream().collect(Collectors.toMap(b -> b.getEndpointAuthName(), b -> b));
        this.modeledClientConfig = new ArrayList<ClientConfig>();
        service.getTrait(ClientContextParamsTrait.class).ifPresent(clientContext -> clientContext.getParameters().forEach((name, param) -> {
            String paramType = GenerationContext.getRubyTypeForParam(symbolProvider, param);
            ClientConfig.Builder builder = ClientConfig.builder().name(RubyFormatter.toSnakeCase(name)).documentationRbsAndValidationType(paramType);
            param.getDocumentation().ifPresent(d -> builder.documentation((String)d));
            this.modeledClientConfig.add(builder.build());
        }));
        this.endpointRuleSet = service.getTrait(EndpointRuleSetTrait.class).map(t -> EndpointRuleSet.fromNode((Node)t.getRuleSet())).orElseGet(GenerationContext::defaultRuleset);
        HashSet<AuthScheme> allAuthSchemes = new HashSet<AuthScheme>(applicationTransport.defaultAuthSchemes());
        AuthScheme anonymousAuthScheme = AnonymousAuthSchemeFactory.build();
        allAuthSchemes.add(anonymousAuthScheme);
        this.integrations().forEach(i -> i.getAdditionalAuthSchemes(this).forEach(s -> allAuthSchemes.add((AuthScheme)s)));
        TreeSet<AuthScheme> serviceAuthSchemes = new TreeSet<AuthScheme>(Comparator.comparing(AuthScheme::getRubyAuthScheme));
        serviceAuthSchemes.add(anonymousAuthScheme);
        service.getOperations().stream().forEach(operation -> ServiceIndex.of((Model)model).getEffectiveAuthSchemes((ToShapeId)service, (ToShapeId)operation, ServiceIndex.AuthSchemeMode.NO_AUTH_AWARE).forEach((shapeId, trait) -> serviceAuthSchemes.add(allAuthSchemes.stream().filter(s -> s.getShapeId().equals(shapeId)).findFirst().orElseThrow(() -> new IllegalStateException("No auth scheme found for " + shapeId)))));
        this.serviceAuthSchemes = Collections.unmodifiableSet(serviceAuthSchemes);
        TreeSet<AuthParam> authParams = new TreeSet<AuthParam>(Comparator.comparing(AuthParam::getName));
        authParams.add(AuthParam.OPERATION_NAME);
        serviceAuthSchemes.forEach(s -> authParams.addAll(s.getAdditionalAuthParams()));
        this.authParams = Collections.unmodifiableSet(authParams);
        this.writerDelegator = new WriterDelegator(fileManifest, symbolProvider, (SymbolWriter.Factory)new RubyCodeWriter.Factory());
    }

    private static EndpointRuleSet defaultRuleset() {
        return EndpointRuleSet.builder().parameters(Parameters.builder().addParameter(BuiltIns.SDK_ENDPOINT).build()).addRule(EndpointRule.builder().validateOrElse("Endpoint is not set - you must configure an endpoint.", new ToCondition[]{BuiltIns.SDK_ENDPOINT.isSet()}).endpoint(Endpoint.builder().url(BuiltIns.SDK_ENDPOINT.toExpression()).build())).build();
    }

    private static String getRubyTypeForParam(SymbolProvider symbolProvider, ClientContextParamDefinition param) {
        return symbolProvider.toSymbol((Shape)param.getType().createBuilderForType().id("smithy#temp").build()).expectProperty("docType").toString();
    }

    public Model model() {
        return this.model;
    }

    public RubySettings settings() {
        return this.rubySettings;
    }

    public SymbolProvider symbolProvider() {
        return this.symbolProvider;
    }

    public FileManifest fileManifest() {
        return this.fileManifest;
    }

    public WriterDelegator<RubyCodeWriter> writerDelegator() {
        return this.writerDelegator;
    }

    public List<RubyIntegration> integrations() {
        return this.integrations;
    }

    public ServiceShape service() {
        return this.service;
    }

    public ApplicationTransport applicationTransport() {
        return this.applicationTransport;
    }

    public ShapeId protocol() {
        return this.protocol;
    }

    public Optional<ProtocolGenerator> protocolGenerator() {
        return this.protocolGenerator;
    }

    public Set<RubyDependency> getRubyDependencies() {
        HashSet<RubyDependency> rubyDependencies = new HashSet<RubyDependency>();
        rubyDependencies.addAll(this.settings().getBaseDependencies());
        rubyDependencies.addAll(this.integrations.stream().map(integration -> integration.getAdditionalGemDependencies(this)).flatMap(Collection::stream).collect(Collectors.toSet()));
        return Collections.unmodifiableSet(rubyDependencies);
    }

    public Set<RubyRuntimePlugin> getRuntimePlugins() {
        return this.integrations.stream().map(i -> i.getRuntimePlugins(this)).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }

    public Set<AuthScheme> getServiceAuthSchemes() {
        return this.serviceAuthSchemes;
    }

    public Set<AuthParam> getAuthParams() {
        return this.authParams;
    }

    public Optional<BuiltInBinding> getBuiltInBinding(String builtIn) {
        return Optional.ofNullable(this.rulesEngineBuiltIns.get(builtIn));
    }

    public Optional<FunctionBinding> getFunctionBinding(String id) {
        return Optional.ofNullable(this.rulesEngineFunctions.get(id));
    }

    public Optional<AuthSchemeBinding> getAuthSchemeBinding(String endpointAuthName) {
        return Optional.ofNullable(this.rulesEngineAuthSchemes.get(endpointAuthName));
    }

    public Map<String, BuiltInBinding> getBuiltInBindings() {
        return Map.copyOf(this.rulesEngineBuiltIns);
    }

    public Map<String, FunctionBinding> getFunctionBindings() {
        return Map.copyOf(this.rulesEngineFunctions);
    }

    public List<BuiltInBinding> getBuiltInBindingsFromEndpointRules() {
        ArrayList<BuiltInBinding> builtInBindings = new ArrayList<BuiltInBinding>();
        this.endpointRuleSet.getParameters().forEach(b -> {
            if (b.isBuiltIn()) {
                builtInBindings.add(this.getBuiltInBinding((String)b.getBuiltIn().get()).orElseThrow(() -> new SmithyBuildException("Unable to find BuiltinBinding for " + b.getName())));
            }
        });
        return builtInBindings;
    }

    public List<ClientConfig> getModeledClientConfig() {
        return List.copyOf(this.modeledClientConfig);
    }

    public EndpointRuleSet getEndpointRuleSet() {
        return this.endpointRuleSet;
    }
}

