/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.codegen.core.directed.ContextualDirective;
import software.amazon.smithy.codegen.core.directed.CreateContextDirective;
import software.amazon.smithy.codegen.core.directed.CreateSymbolProviderDirective;
import software.amazon.smithy.codegen.core.directed.CustomizeDirective;
import software.amazon.smithy.codegen.core.directed.DirectedCodegen;
import software.amazon.smithy.codegen.core.directed.GenerateEnumDirective;
import software.amazon.smithy.codegen.core.directed.GenerateErrorDirective;
import software.amazon.smithy.codegen.core.directed.GenerateIntEnumDirective;
import software.amazon.smithy.codegen.core.directed.GenerateServiceDirective;
import software.amazon.smithy.codegen.core.directed.GenerateStructureDirective;
import software.amazon.smithy.codegen.core.directed.GenerateUnionDirective;
import software.amazon.smithy.codegen.core.directed.ShapeDirective;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.ruby.codegen.ApplicationTransport;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.ProtocolGenerator;
import software.amazon.smithy.ruby.codegen.RubyIntegration;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.RubySymbolProvider;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;
import software.amazon.smithy.ruby.codegen.generators.AuthGenerator;
import software.amazon.smithy.ruby.codegen.generators.ClientGenerator;
import software.amazon.smithy.ruby.codegen.generators.ConfigGenerator;
import software.amazon.smithy.ruby.codegen.generators.EndpointGenerator;
import software.amazon.smithy.ruby.codegen.generators.EnumGenerator;
import software.amazon.smithy.ruby.codegen.generators.GemspecGenerator;
import software.amazon.smithy.ruby.codegen.generators.HttpProtocolTestGenerator;
import software.amazon.smithy.ruby.codegen.generators.IntEnumGenerator;
import software.amazon.smithy.ruby.codegen.generators.MiddlewareGenerator;
import software.amazon.smithy.ruby.codegen.generators.ModuleGenerator;
import software.amazon.smithy.ruby.codegen.generators.PaginatorsGenerator;
import software.amazon.smithy.ruby.codegen.generators.ParamsGenerator;
import software.amazon.smithy.ruby.codegen.generators.SpecHelperGenerator;
import software.amazon.smithy.ruby.codegen.generators.SteepfileGenerator;
import software.amazon.smithy.ruby.codegen.generators.StructureGenerator;
import software.amazon.smithy.ruby.codegen.generators.TypesFileBlockGenerator;
import software.amazon.smithy.ruby.codegen.generators.UnionGenerator;
import software.amazon.smithy.ruby.codegen.generators.ValidatorsGenerator;
import software.amazon.smithy.ruby.codegen.generators.VersionGenerator;
import software.amazon.smithy.ruby.codegen.generators.WaitersGenerator;
import software.amazon.smithy.ruby.codegen.generators.YardOptsGenerator;
import software.amazon.smithy.ruby.codegen.middleware.MiddlewareBuilder;
import software.amazon.smithy.ruby.codegen.rulesengine.AuthSchemeBinding;
import software.amazon.smithy.ruby.codegen.rulesengine.BuiltInBinding;
import software.amazon.smithy.ruby.codegen.rulesengine.FunctionBinding;

public class DirectedRubyCodegen
implements DirectedCodegen<GenerationContext, RubySettings, RubyIntegration> {
    private TypesFileBlockGenerator typesFileBlockGenerator;

    public SymbolProvider createSymbolProvider(CreateSymbolProviderDirective<RubySettings> directive) {
        return new RubySymbolProvider(directive.model(), (RubySettings)directive.settings());
    }

    public GenerationContext createContext(CreateContextDirective<RubySettings, RubyIntegration> directive) {
        ServiceShape service = directive.service();
        Model model = directive.model();
        List<RubyIntegration> integrations = directive.integrations().stream().filter(integration -> integration.includeFor(service, model)).collect(Collectors.toList());
        Map<ShapeId, ProtocolGenerator> supportedProtocols = ProtocolGenerator.collectSupportedProtocolGenerators(integrations);
        ShapeId protocol = ((RubySettings)directive.settings()).resolveServiceProtocol(service, model, supportedProtocols.keySet());
        Optional<ProtocolGenerator> protocolGenerator = ProtocolGenerator.resolve(protocol, integrations);
        ApplicationTransport applicationTransport = protocolGenerator.isPresent() ? protocolGenerator.get().getApplicationTransport() : ApplicationTransport.createDefaultHttpApplicationTransport();
        ArrayList<BuiltInBinding> rulesEngineBuiltInBindings = new ArrayList<BuiltInBinding>();
        rulesEngineBuiltInBindings.addAll(BuiltInBinding.defaultBuiltInBindings());
        integrations.forEach(integration -> rulesEngineBuiltInBindings.addAll(integration.builtInBindings()));
        ArrayList<FunctionBinding> rulesEngineFunctionBindings = new ArrayList<FunctionBinding>();
        rulesEngineFunctionBindings.addAll(FunctionBinding.standardLibraryFunctions());
        integrations.forEach(integration -> rulesEngineFunctionBindings.addAll(integration.functionBindings()));
        ArrayList<AuthSchemeBinding> rulesEngineAuthSchemeBindings = new ArrayList<AuthSchemeBinding>();
        rulesEngineAuthSchemeBindings.addAll(AuthSchemeBinding.standardAuthSchemes());
        integrations.forEach(integration -> rulesEngineAuthSchemeBindings.addAll(integration.authSchemeBindings()));
        GenerationContext context = new GenerationContext((RubySettings)directive.settings(), directive.fileManifest(), integrations, model, service, protocol, protocolGenerator, applicationTransport, directive.symbolProvider(), rulesEngineBuiltInBindings, rulesEngineFunctionBindings, rulesEngineAuthSchemeBindings);
        return context;
    }

    public void generateService(GenerateServiceDirective<GenerationContext, RubySettings> directive) {
        GenerationContext context = (GenerationContext)directive.context();
        MiddlewareBuilder middlewareBuilder = new MiddlewareBuilder();
        middlewareBuilder.addDefaultMiddleware(context);
        context.integrations().forEach(integration -> integration.modifyClientMiddleware(middlewareBuilder, context));
        context.protocolGenerator().ifPresent(g -> g.modifyClientMiddleware(middlewareBuilder, context));
        HashSet unorderedConfig = new HashSet();
        context.applicationTransport().getClientConfig().forEach(c -> c.addToConfigCollection(unorderedConfig));
        middlewareBuilder.getClientConfig(context).forEach(c -> c.addToConfigCollection(unorderedConfig));
        context.integrations().forEach(i -> i.getAdditionalClientConfig(context).forEach(c -> c.addToConfigCollection(unorderedConfig)));
        context.protocolGenerator().ifPresent(g -> g.getAdditionalClientConfig(context).forEach(c -> c.addToConfigCollection(unorderedConfig)));
        context.getBuiltInBindingsFromEndpointRules().forEach(b -> b.getClientConfig().forEach(c -> c.addToConfigCollection(unorderedConfig)));
        context.getModeledClientConfig().forEach(c -> c.addToConfigCollection(unorderedConfig));
        List<ClientConfig> clientConfigList = unorderedConfig.stream().sorted(Comparator.comparing(ClientConfig::getName)).collect(Collectors.toList());
        ConfigGenerator configGenerator = new ConfigGenerator((ContextualDirective<GenerationContext, RubySettings>)directive, clientConfigList);
        configGenerator.render();
        configGenerator.renderRbs();
        MiddlewareGenerator middlewareGenerator = new MiddlewareGenerator(directive, middlewareBuilder);
        middlewareGenerator.render();
        ClientGenerator clientGenerator = new ClientGenerator(directive, clientConfigList);
        clientGenerator.render();
        clientGenerator.renderRbs();
    }

    public void customizeBeforeShapeGeneration(CustomizeDirective<GenerationContext, RubySettings> directive) {
        this.typesFileBlockGenerator = new TypesFileBlockGenerator((ContextualDirective<GenerationContext, RubySettings>)directive);
        this.typesFileBlockGenerator.openBlocks();
    }

    public void generateStructure(GenerateStructureDirective<GenerationContext, RubySettings> directive) {
        new StructureGenerator((ShapeDirective<StructureShape, GenerationContext, RubySettings>)directive).render();
    }

    public void generateError(GenerateErrorDirective<GenerationContext, RubySettings> directive) {
        new StructureGenerator((ShapeDirective<StructureShape, GenerationContext, RubySettings>)directive).render();
    }

    public void generateUnion(GenerateUnionDirective<GenerationContext, RubySettings> directive) {
        new UnionGenerator(directive).render();
    }

    public void generateEnumShape(GenerateEnumDirective<GenerationContext, RubySettings> directive) {
        new EnumGenerator(directive).render();
    }

    public void generateIntEnumShape(GenerateIntEnumDirective<GenerationContext, RubySettings> directive) {
        new IntEnumGenerator(directive).render();
    }

    public void customizeBeforeIntegrations(CustomizeDirective<GenerationContext, RubySettings> directive) {
        GenerationContext context = (GenerationContext)directive.context();
        new ParamsGenerator((ContextualDirective<GenerationContext, RubySettings>)directive).render();
        new ValidatorsGenerator((ContextualDirective<GenerationContext, RubySettings>)directive).render();
        if (((GenerationContext)directive.context()).protocolGenerator().isPresent()) {
            ProtocolGenerator generator = ((GenerationContext)directive.context()).protocolGenerator().get();
            generator.generateBuilders((GenerationContext)directive.context());
            generator.generateParsers((GenerationContext)directive.context());
            generator.generateErrors((GenerationContext)directive.context());
            generator.generateStubs((GenerationContext)directive.context());
        }
        AuthGenerator authGenerator = new AuthGenerator((ContextualDirective<GenerationContext, RubySettings>)directive);
        authGenerator.render();
        authGenerator.renderRbs();
        EndpointGenerator endpointGenerator = new EndpointGenerator((ContextualDirective<GenerationContext, RubySettings>)directive);
        endpointGenerator.render();
        endpointGenerator.renderRbs();
        PaginatorsGenerator paginatorsGenerator = new PaginatorsGenerator((ContextualDirective<GenerationContext, RubySettings>)directive);
        paginatorsGenerator.render();
        paginatorsGenerator.renderRbs();
        WaitersGenerator waitersGenerator = new WaitersGenerator(directive);
        waitersGenerator.render();
        waitersGenerator.renderRbs();
        new VersionGenerator((ContextualDirective<GenerationContext, RubySettings>)directive).render();
        new ModuleGenerator((ContextualDirective<GenerationContext, RubySettings>)directive).render();
        new GemspecGenerator(context).render();
        new YardOptsGenerator(context).render();
        new SteepfileGenerator(context).render();
        new SpecHelperGenerator(context).render();
        if (context.applicationTransport().isHttpTransport()) {
            HttpProtocolTestGenerator testGenerator = new HttpProtocolTestGenerator(context);
            testGenerator.render();
        }
    }

    public void customizeAfterIntegrations(CustomizeDirective<GenerationContext, RubySettings> directive) {
        this.typesFileBlockGenerator.closeAllBlocks();
    }
}

