/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.util;

import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.RequiresLengthTrait;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class Streaming {
    private Streaming() {
    }

    public static boolean isEventStreaming(Model model, OperationShape operationShape) {
        StructureShape input = (StructureShape)model.expectShape(operationShape.getInputShape(), StructureShape.class);
        StructureShape output = (StructureShape)model.expectShape(operationShape.getOutputShape(), StructureShape.class);
        return Streaming.isEventStreaming(model, (Shape)input) || Streaming.isEventStreaming(model, (Shape)output);
    }

    public static boolean isEventStreaming(Model model, Shape inputOrOutput) {
        return inputOrOutput.members().stream().anyMatch(m -> StreamingTrait.isEventStream((Model)model, (MemberShape)m));
    }

    public static boolean isStreaming(Model model, Shape inputOrOutput) {
        return inputOrOutput.members().stream().anyMatch(m -> m.getMemberTrait(model, StreamingTrait.class).isPresent());
    }

    public static boolean isNonFiniteStreaming(Model model, Shape inputOrOutput) {
        return inputOrOutput.members().stream().anyMatch(m -> m.getMemberTrait(model, StreamingTrait.class).isPresent() && !m.getMemberTrait(model, RequiresLengthTrait.class).isPresent());
    }
}

