/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.traits;

import java.util.List;
import java.util.Optional;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.ruby.codegen.traits.SkipTest;
import software.amazon.smithy.utils.ListUtils;

public final class SkipTestsTrait
extends AbstractTrait {
    public static final ShapeId ID = ShapeId.from((String)"smithy.ruby#skipTests");
    private final List<SkipTest> skipTests;

    public SkipTestsTrait(List<SkipTest> skipTests) {
        this(SourceLocation.NONE, skipTests);
    }

    public SkipTestsTrait(SourceLocation sourceLocation, List<SkipTest> skipTests) {
        super(ID, (FromSourceLocation)sourceLocation);
        this.skipTests = ListUtils.copyOf(skipTests);
    }

    public List<SkipTest> getSkipTests() {
        return this.skipTests;
    }

    public Optional<SkipTest> skipTest(String testId, String testType) {
        return this.skipTests.stream().filter(skipTest -> skipTest.getId().equals(testId) && skipTest.getType().map(t -> t.equals(testType)).orElse(true) != false).findFirst();
    }

    protected Node createNode() {
        return (Node)this.getSkipTests().stream().collect(ArrayNode.collect());
    }

    public static final class Provider
    implements TraitService {
        public ShapeId getShapeId() {
            return ID;
        }

        public Trait createTrait(ShapeId target, Node value) {
            ArrayNode values = value.expectArrayNode();
            List skipTests = values.getElementsAs(SkipTest::fromNode);
            SkipTestsTrait result = new SkipTestsTrait(value.getSourceLocation(), skipTests);
            result.setNodeCache(value);
            return result;
        }
    }
}

