/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators.docs;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class ResponseExampleGenerator {
    private final OperationShape operation;
    private final RubyCodeWriter writer;
    private final Set<ShapeId> visited;
    private final SymbolProvider symbolProvider;
    private final Model model;

    public ResponseExampleGenerator(OperationShape operation, SymbolProvider symbolProvider, Model model) {
        this.operation = operation;
        this.symbolProvider = symbolProvider;
        this.model = model;
        this.writer = new RubyCodeWriter("");
        this.visited = new HashSet<ShapeId>();
    }

    public String generate() {
        Shape operationOutput = this.model.expectShape(this.operation.getOutputShape());
        operationOutput.accept((ShapeVisitor)new ResponseMember("resp.data", this.visited));
        return this.writer.toString();
    }

    private final class ResponseMember
    extends ShapeVisitor.Default<Void> {
        private final String dataGetter;
        private final Set<ShapeId> visited;

        private ResponseMember(String dataGetter, Set<ShapeId> visited) {
            this.dataGetter = dataGetter;
            this.visited = visited;
        }

        protected Void getDefault(Shape shape) {
            ResponseExampleGenerator.this.writer.write("$L #=> $L", new Object[]{this.dataGetter, ResponseExampleGenerator.this.symbolProvider.toSymbol(shape).getProperty("docType").orElse("")});
            return null;
        }

        public Void stringShape(StringShape shape) {
            if (shape.hasTrait(EnumTrait.class)) {
                EnumTrait enumTrait = (EnumTrait)shape.expectTrait(EnumTrait.class);
                String values = enumTrait.getEnumDefinitionValues().stream().map(value -> "\"" + value + "\"").collect(Collectors.joining(", "));
                ResponseExampleGenerator.this.writer.write("$L #=> String, one of [$L]", new Object[]{this.dataGetter, values});
            } else {
                ResponseExampleGenerator.this.writer.write("$L #=> String", new Object[]{this.dataGetter});
            }
            return null;
        }

        public Void structureShape(StructureShape shape) {
            ResponseExampleGenerator.this.writer.write("$L #=> Types::$L", new Object[]{this.dataGetter, ResponseExampleGenerator.this.symbolProvider.toSymbol((Shape)shape).getProperty("docType").orElse("")});
            if (!this.visited.add(shape.getId())) {
                return null;
            }
            shape.members().forEach(member -> {
                Shape target = ResponseExampleGenerator.this.model.expectShape(member.getTarget());
                String memberGetter = this.dataGetter + "." + ResponseExampleGenerator.this.symbolProvider.toMemberName(member);
                target.accept((ShapeVisitor)new ResponseMember(memberGetter, this.visited));
            });
            return null;
        }

        public Void listShape(ListShape shape) {
            ResponseExampleGenerator.this.writer.write("$L #=> $L", new Object[]{this.dataGetter, ResponseExampleGenerator.this.symbolProvider.toSymbol((Shape)shape).getProperty("docType").orElse("")});
            if (!this.visited.add(shape.getId())) {
                return null;
            }
            Shape target = ResponseExampleGenerator.this.model.expectShape(shape.getMember().getTarget());
            if (!this.visited.contains(target.getId())) {
                String memberGetter = this.dataGetter + "[0]";
                target.accept((ShapeVisitor)new ResponseMember(memberGetter, this.visited));
            }
            return null;
        }

        public Void mapShape(MapShape shape) {
            ResponseExampleGenerator.this.writer.write("$L #=> $L", new Object[]{this.dataGetter, ResponseExampleGenerator.this.symbolProvider.toSymbol((Shape)shape).getProperty("docType").orElse("")});
            if (!this.visited.add(shape.getId())) {
                return null;
            }
            Shape target = ResponseExampleGenerator.this.model.expectShape(shape.getValue().getTarget());
            if (!this.visited.contains(target.getId())) {
                String memberGetter = this.dataGetter + "['key']";
                target.accept((ShapeVisitor)new ResponseMember(memberGetter, this.visited));
            }
            return null;
        }

        public Void unionShape(UnionShape shape) {
            String values = shape.getAllMembers().values().stream().map(arg_0 -> ((SymbolProvider)ResponseExampleGenerator.this.symbolProvider).toMemberName(arg_0)).collect(Collectors.joining(", "));
            ResponseExampleGenerator.this.writer.write("$L #=> Types::$L, one of [$L]", new Object[]{this.dataGetter, ResponseExampleGenerator.this.symbolProvider.toSymbol((Shape)shape).getProperty("docType").orElse("").toString(), values});
            if (!this.visited.add(shape.getId())) {
                return null;
            }
            shape.members().forEach(member -> {
                Shape target = ResponseExampleGenerator.this.model.expectShape(member.getTarget());
                String memberGetter = this.dataGetter + "." + RubyFormatter.toSnakeCase(ResponseExampleGenerator.this.symbolProvider.toMemberName(member));
                target.accept((ShapeVisitor)new ResponseMember(memberGetter, this.visited));
            });
            return null;
        }
    }
}

