/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.directed.ContextualDirective;
import software.amazon.smithy.codegen.core.directed.ShapeDirective;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NullableIndex;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.SensitiveTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.generators.RubyGeneratorBase;
import software.amazon.smithy.ruby.codegen.generators.docs.ShapeDocumentationGenerator;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public final class StructureGenerator
extends RubyGeneratorBase {
    private final StructureShape shape;
    private final NullableIndex nullableIndex;

    public StructureGenerator(ShapeDirective<StructureShape, GenerationContext, RubySettings> directive) {
        super((ContextualDirective<GenerationContext, RubySettings>)directive);
        this.shape = (StructureShape)directive.shape();
        this.nullableIndex = NullableIndex.of((Model)this.model);
    }

    @Override
    String getModule() {
        return "Types";
    }

    public void render() {
        this.write(writer -> {
            if (this.shape.getId().getName().equals("Struct")) {
                writer.apiPrivate().write("class ::Struct; end\n", new Object[0]);
            }
            new ShapeDocumentationGenerator(this.model, (RubyCodeWriter)((Object)writer), this.symbolProvider, (Shape)this.shape).render();
            this.renderStructureInitializeMethodDocumentation((RubyCodeWriter)((Object)writer));
            this.renderStructureAttributesDocumentation((RubyCodeWriter)((Object)writer));
            Object membersBlock = "nil";
            if (!this.shape.members().isEmpty()) {
                membersBlock = this.shape.members().stream().map(memberShape -> RubyFormatter.asSymbol(this.symbolProvider.toMemberName(memberShape))).collect(Collectors.joining(",\n"));
            }
            membersBlock = (String)membersBlock + ",";
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("$T = ::Struct.new(", new Object[]{this.symbolProvider.toSymbol((Shape)this.shape)})).write(membersBlock, new Object[0])).write("keyword_init: true", new Object[0])).closeBlock(") do", new Object[0])).indent()).write("include $T", new Object[]{Hearth.STRUCTURE})).call(() -> this.renderStructureInitializeMethod((RubyCodeWriter)((Object)writer), this.shape))).call(() -> this.renderStructureToSMethod((RubyCodeWriter)((Object)writer), this.model, this.shape))).closeBlock("end\n", new Object[0]);
        });
        this.writeRbs(writer -> {
            String shapeName = this.symbolProvider.toSymbol((Shape)this.shape).getName();
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("class $L < ::Struct[untyped]", new Object[]{shapeName})).write("include $L", new Object[]{Hearth.STRUCTURE})).call(() -> this.shape.members().forEach(memberShape -> {
                String name = this.symbolProvider.toMemberName(memberShape);
                Symbol target = this.symbolProvider.toSymbol(this.model.expectShape(memberShape.getTarget()));
                writer.write("attr_accessor $L (): $L", new Object[]{name, target.getProperty("rbsType").get()});
            }))).closeBlock("end", new Object[0]);
        });
    }

    private void renderStructureInitializeMethod(RubyCodeWriter writer, StructureShape structureShape) {
        List<MemberShape> defaultMembers = structureShape.members().stream().filter(m -> !this.nullableIndex.isNullable((ToShapeId)m)).toList();
        if (!defaultMembers.isEmpty()) {
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("\ndef initialize(*)", new Object[0])).write("super", new Object[0])).call(() -> defaultMembers.forEach(m -> {
                String attribute = this.symbolProvider.toMemberName(m);
                Shape target = this.model.expectShape(m.getTarget());
                writer.write("self.$L ||= $L", new Object[]{attribute, target.accept((ShapeVisitor)new MemberDefaultVisitor())});
            }))).closeBlock("end", new Object[0]);
        }
    }

    private void renderStructureInitializeMethodDocumentation(RubyCodeWriter writer) {
        writer.writeYardMethod("initialize(params = {})", () -> {
            writer.writeYardParam("Hash", "params", "");
            this.shape.members().forEach(memberShape -> {
                String param = RubyFormatter.asSymbol(this.symbolProvider.toMemberName(memberShape));
                Shape target = this.model.expectShape(memberShape.getTarget());
                String paramType = (String)this.symbolProvider.toSymbol(target).getProperty("docType").orElseThrow(IllegalArgumentException::new);
                String defaultValue = "";
                if (!this.nullableIndex.isNullable((ToShapeId)memberShape)) {
                    defaultValue = (String)target.accept((ShapeVisitor)new MemberDefaultVisitor());
                }
                writer.writeYardOption("params", paramType, param, defaultValue, "");
            });
        });
    }

    private void renderStructureAttributesDocumentation(RubyCodeWriter writer) {
        this.shape.members().forEach(memberShape -> {
            String attribute = this.symbolProvider.toMemberName(memberShape);
            Shape target = this.model.expectShape(memberShape.getTarget());
            String returnType = (String)this.symbolProvider.toSymbol(target).getProperty("docType").orElseThrow(IllegalArgumentException::new);
            writer.writeYardAttribute(attribute, () -> {
                new ShapeDocumentationGenerator(this.model, writer, this.symbolProvider, (Shape)memberShape).render();
                writer.writeYardReturn(returnType, "");
            });
        });
    }

    private void renderStructureToSMethod(RubyCodeWriter writer, Model model, StructureShape structureShape) {
        String fullQualifiedShapeName = this.settings.getModule() + "::Types::" + this.symbolProvider.toSymbol((Shape)structureShape).getName();
        boolean hasSensitiveMember = structureShape.members().stream().anyMatch(memberShape -> memberShape.getMemberTrait(model, SensitiveTrait.class).isPresent());
        if (structureShape.hasTrait(SensitiveTrait.class)) {
            ((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("\ndef to_s", new Object[0])).write("\"#<struct $L [SENSITIVE]>\"", new Object[]{fullQualifiedShapeName})).closeBlock("end", new Object[0]);
        } else if (hasSensitiveMember) {
            Iterator iterator = structureShape.members().iterator();
            ((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("\ndef to_s", new Object[0])).write("\"#<struct $L \"\\", new Object[]{fullQualifiedShapeName})).indent();
            while (iterator.hasNext()) {
                MemberShape memberShape2 = (MemberShape)iterator.next();
                String key = this.symbolProvider.toMemberName(memberShape2);
                Object value = "#{" + key + " || 'nil'}";
                if (memberShape2.isBlobShape() || memberShape2.isStringShape()) {
                    value = "\"" + (String)value + "\"";
                } else if (memberShape2.getMemberTrait(model, SensitiveTrait.class).isPresent()) {
                    value = "\\\"[SENSITIVE]\\\"";
                }
                if (iterator.hasNext()) {
                    writer.write("\"$L=$L, \"\\", new Object[]{key, value});
                    continue;
                }
                writer.write("\"$L=$L>\"", new Object[]{key, value});
            }
            ((RubyCodeWriter)writer.dedent()).closeBlock("end", new Object[0]);
        }
    }

    private static class MemberDefaultVisitor
    extends ShapeVisitor.Default<String> {
        private MemberDefaultVisitor() {
        }

        protected String getDefault(Shape shape) {
            return "0";
        }

        public String booleanShape(BooleanShape s) {
            return "false";
        }
    }
}

