/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.model.traits.HttpErrorTrait;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.HttpLabelTrait;
import software.amazon.smithy.model.traits.HttpPayloadTrait;
import software.amazon.smithy.model.traits.HttpPrefixHeadersTrait;
import software.amazon.smithy.model.traits.HttpQueryParamsTrait;
import software.amazon.smithy.model.traits.HttpQueryTrait;
import software.amazon.smithy.model.traits.HttpResponseCodeTrait;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.MediaTypeTrait;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyImportContainer;
import software.amazon.smithy.ruby.codegen.generators.StubsGeneratorBase;
import software.amazon.smithy.ruby.codegen.util.TimestampFormat;

public abstract class RestStubsGeneratorBase
extends StubsGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger(RestStubsGeneratorBase.class.getName());

    public RestStubsGeneratorBase(GenerationContext context) {
        super(context);
    }

    protected abstract void renderPayloadBodyStub(Shape var1, MemberShape var2, Shape var3);

    protected abstract void renderBodyStub(Shape var1);

    @Override
    protected void renderOperationStubMethod(OperationShape operation, Shape outputShape) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("def self.stub(http_resp, stub:)", new Object[0])).write("data = {}", new Object[0])).call(() -> this.renderStatusCodeStubber(operation))).call(() -> this.renderHeaderStubbers(outputShape))).call(() -> this.renderPrefixHeadersStubbers(outputShape))).call(() -> this.renderResponseCodeStubber(outputShape))).call(() -> this.renderBodyStubber(outputShape))).closeBlock("end", new Object[0]);
    }

    @Override
    protected void renderErrorStubMethod(Shape errorShape) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("def self.stub(http_resp, stub:)", new Object[0])).write("data = {}", new Object[0])).call(() -> this.renderStatusCodeStubber(errorShape))).call(() -> this.renderHeaderStubbers(errorShape))).call(() -> this.renderPrefixHeadersStubbers(errorShape))).call(() -> this.renderResponseCodeStubber(errorShape))).call(() -> this.renderBodyStubber(errorShape))).closeBlock("end", new Object[0]);
    }

    protected void renderBodyStubber(Shape shape) {
        boolean serializeBody = shape.members().stream().anyMatch(m -> !m.hasTrait(HttpLabelTrait.class) && !m.hasTrait(HttpQueryTrait.class) && !m.hasTrait(HttpQueryParamsTrait.class) && !m.hasTrait(HttpHeaderTrait.class) && !m.hasTrait(HttpPrefixHeadersTrait.class) && !m.hasTrait(HttpResponseCodeTrait.class));
        List httpPayloadMembers = shape.members().stream().filter(m -> m.hasTrait(HttpPayloadTrait.class)).collect(Collectors.toList());
        if (httpPayloadMembers.size() == 0) {
            if (serializeBody) {
                this.renderBodyStub(shape);
            }
        } else {
            MemberShape payloadMember = (MemberShape)httpPayloadMembers.get(0);
            Shape target = this.model.expectShape(payloadMember.getTarget());
            this.renderPayloadBodyStub(shape, payloadMember, target);
        }
    }

    protected void renderStatusCodeStubber(OperationShape operation) {
        operation.getTrait(HttpTrait.class).ifPresent(httpTrait -> this.writer.write("http_resp.status = $1L", new Object[]{httpTrait.getCode()}));
    }

    protected void renderStatusCodeStubber(Shape errorShape) {
        String statusCode = "";
        Optional optionalHttpErrorTrait = errorShape.getTrait(HttpErrorTrait.class);
        if (optionalHttpErrorTrait.isPresent()) {
            statusCode = Integer.toString(((HttpErrorTrait)optionalHttpErrorTrait.get()).getCode());
        } else {
            ErrorTrait errorTrait = (ErrorTrait)errorShape.getTrait(ErrorTrait.class).get();
            if (errorTrait.isClientError()) {
                statusCode = "400";
            } else if (errorTrait.isServerError()) {
                statusCode = "500";
            }
        }
        this.writer.write("http_resp.status = $1L", new Object[]{statusCode});
    }

    protected void renderHeaderStubbers(Shape shape) {
        List headerMembers = shape.members().stream().filter(m -> m.hasTrait(HttpHeaderTrait.class)).collect(Collectors.toList());
        for (MemberShape m2 : headerMembers) {
            HttpHeaderTrait headerTrait = (HttpHeaderTrait)m2.expectTrait(HttpHeaderTrait.class);
            String symbolName = ":" + this.symbolProvider.toMemberName(m2);
            String headerSetter = "http_resp.headers['" + headerTrait.getValue() + "'] = ";
            String valueGetter = "stub[" + symbolName + "]";
            this.model.expectShape(m2.getTarget()).accept((ShapeVisitor)new HeaderSerializer(m2, headerSetter, valueGetter));
        }
    }

    protected void renderPrefixHeadersStubbers(Shape shape) {
        List headerMembers = shape.members().stream().filter(m -> m.hasTrait(HttpPrefixHeadersTrait.class)).collect(Collectors.toList());
        for (MemberShape m2 : headerMembers) {
            HttpPrefixHeadersTrait headerTrait = (HttpPrefixHeadersTrait)m2.expectTrait(HttpPrefixHeadersTrait.class);
            String prefix = headerTrait.getValue();
            MapShape targetShape = (MapShape)this.model.expectShape(m2.getTarget(), MapShape.class);
            Shape valueShape = this.model.expectShape(targetShape.getValue().getTarget());
            String symbolName = ":" + this.symbolProvider.toMemberName(m2);
            String headerSetter = "http_resp.headers[\"" + prefix + "#{key}\"] = ";
            ((RubyCodeWriter)((RubyCodeWriter)this.writer.openBlock("stub[$L]&.each do |key, value|", new Object[]{symbolName})).call(() -> valueShape.accept((ShapeVisitor)new HeaderSerializer(m2, headerSetter, "value")))).closeBlock("end", new Object[0]);
        }
    }

    protected void renderResponseCodeStubber(Shape shape) {
        List responseCodeMembers = shape.members().stream().filter(m -> m.hasTrait(HttpResponseCodeTrait.class)).collect(Collectors.toList());
        if (responseCodeMembers.size() == 1) {
            MemberShape responseCodeMember = (MemberShape)responseCodeMembers.get(0);
            this.writer.write("http_resp.status = stub[:$L]", new Object[]{this.symbolProvider.toMemberName(responseCodeMember)});
        }
    }

    protected void renderStreamingStub(Shape inputShape) {
        MemberShape streamingMember = inputShape.members().stream().filter(m -> m.getMemberTrait(this.model, StreamingTrait.class).isPresent()).findFirst().get();
        this.writer.write("IO.copy_stream(stub[:$L], http_resp.body)", new Object[]{this.symbolProvider.toMemberName(streamingMember)});
    }

    private class HeaderSerializer
    extends ShapeVisitor.Default<Void> {
        private final String inputGetter;
        private final String dataSetter;
        private final MemberShape memberShape;

        HeaderSerializer(MemberShape memberShape, String dataSetter, String inputGetter) {
            this.inputGetter = inputGetter;
            this.dataSetter = dataSetter;
            this.memberShape = memberShape;
        }

        protected Void getDefault(Shape shape) {
            RestStubsGeneratorBase.this.writer.write("$1L$2L.to_s unless $2L.nil?", new Object[]{this.dataSetter, this.inputGetter});
            return null;
        }

        private void rubyFloat() {
            RestStubsGeneratorBase.this.writer.write("$1L$3T.serialize($2L) unless $2L.nil?", new Object[]{this.dataSetter, this.inputGetter, Hearth.NUMBER_HELPER});
        }

        public Void doubleShape(DoubleShape shape) {
            this.rubyFloat();
            return null;
        }

        public Void floatShape(FloatShape shape) {
            this.rubyFloat();
            return null;
        }

        public Void stringShape(StringShape shape) {
            if (shape.hasTrait(MediaTypeTrait.class)) {
                RestStubsGeneratorBase.this.writer.write("$1L$3T::encode64($2L).strip unless $2L.nil? || $2L.empty?", new Object[]{this.dataSetter, this.inputGetter, RubyImportContainer.BASE64});
            } else {
                RestStubsGeneratorBase.this.writer.write("$1L$2L unless $2L.nil? || $2L.empty?", new Object[]{this.dataSetter, this.inputGetter});
            }
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            RestStubsGeneratorBase.this.writer.write("$1L$2L unless $3L.nil?", new Object[]{this.dataSetter, TimestampFormat.serializeTimestamp(shape, this.memberShape, this.inputGetter, TimestampFormatTrait.Format.DATE_TIME, false), this.inputGetter});
            return null;
        }

        public Void listShape(ListShape shape) {
            ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)RestStubsGeneratorBase.this.writer.openBlock("unless $1L.nil? || $1L.empty?", new Object[]{this.inputGetter})).write("$1L$2L", new Object[]{this.dataSetter, this.inputGetter})).indent()).write(".compact", new Object[0])).call(() -> RestStubsGeneratorBase.this.model.expectShape(shape.getMember().getTarget()).accept((ShapeVisitor)new HeaderListMemberSerializer(shape.getMember())))).write(".join(', ')", new Object[0])).dedent()).closeBlock("end", new Object[0]);
            return null;
        }

        public Void mapShape(MapShape shape) {
            return null;
        }

        public Void structureShape(StructureShape shape) {
            return null;
        }

        public Void unionShape(UnionShape shape) {
            return null;
        }
    }

    private class HeaderListMemberSerializer
    extends ShapeVisitor.Default<Void> {
        private final MemberShape memberShape;

        HeaderListMemberSerializer(MemberShape memberShape) {
            this.memberShape = memberShape;
        }

        protected Void getDefault(Shape shape) {
            RestStubsGeneratorBase.this.writer.write(".map { |s| s.to_s }", new Object[0]);
            return null;
        }

        public Void stringShape(StringShape shape) {
            RestStubsGeneratorBase.this.writer.write(".map { |s| (s.include?('\"') || s.include?(\",\")) ? \"\\\"#{s.gsub('\"', '\\\"')}\\\"\" : s }", new Object[0]);
            return null;
        }

        public Void timestampShape(TimestampShape shape) {
            RestStubsGeneratorBase.this.writer.write(".map { |s| $L }", new Object[]{TimestampFormat.serializeTimestamp(shape, this.memberShape, "s", TimestampFormatTrait.Format.DATE_TIME, true)});
            return null;
        }
    }
}

