/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import software.amazon.smithy.codegen.core.directed.ContextualDirective;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyDependency;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class ModuleGenerator {
    private static final Logger LOGGER = Logger.getLogger(ModuleGenerator.class.getName());
    private static final String[] DEFAULT_REQUIRES = new String[]{"auth", "builders", "client", "config", "errors", "paginators", "params", "parsers", "stubs", "types", "validators", "waiters"};
    private final GenerationContext context;
    private final RubySettings settings;
    private final Set<RubyDependency> rubyDependencies;

    public ModuleGenerator(ContextualDirective<GenerationContext, RubySettings> directive) {
        this.context = (GenerationContext)directive.context();
        this.settings = (RubySettings)directive.settings();
        this.rubyDependencies = this.context.getRubyDependencies();
    }

    public void render() {
        List additionalFiles = this.context.integrations().stream().map(integration -> integration.writeAdditionalFiles(this.context)).flatMap(Collection::stream).toList();
        String fileName = this.settings.getGemName() + "/lib/" + this.settings.getGemName() + ".rb";
        this.context.writerDelegator().useFileWriter(fileName, this.settings.getModule(), writer -> {
            writer.preamble().includeRequires();
            HashSet indirectDependencies = new HashSet();
            this.rubyDependencies.forEach(rubyDependency -> indirectDependencies.addAll(rubyDependency.getRubyDependencies()));
            this.rubyDependencies.forEach(rubyDependency -> {
                if (!indirectDependencies.contains(rubyDependency)) {
                    writer.write("require '$L'", new Object[]{rubyDependency.getImportPath()});
                }
            });
            writer.write("\n", new Object[0]);
            for (String require : DEFAULT_REQUIRES) {
                writer.write("require_relative '$L/$L'", new Object[]{this.settings.getGemName(), require});
            }
            for (String require : additionalFiles) {
                writer.write("require_relative '$L'", new Object[]{require});
                LOGGER.finer("Adding additional module require: " + require);
            }
            writer.write("", new Object[0]);
            ((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("module $L", new Object[]{this.settings.getModule()})).write("VERSION = File.read(File.expand_path('../VERSION', __dir__)).strip", new Object[0])).closeBlock("end", new Object[0]);
        });
        LOGGER.fine("Wrote module file to " + fileName);
    }
}

