/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.generators;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.smithy.codegen.core.directed.ContextualDirective;
import software.amazon.smithy.codegen.core.directed.GenerateServiceDirective;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.ruby.codegen.GenerationContext;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.RubyCodeWriter;
import software.amazon.smithy.ruby.codegen.RubyFormatter;
import software.amazon.smithy.ruby.codegen.RubyImportContainer;
import software.amazon.smithy.ruby.codegen.RubyRuntimePlugin;
import software.amazon.smithy.ruby.codegen.RubySettings;
import software.amazon.smithy.ruby.codegen.generators.RubyGeneratorBase;
import software.amazon.smithy.ruby.codegen.generators.docs.ShapeDocumentationGenerator;
import software.amazon.smithy.ruby.codegen.middleware.MiddlewareBuilder;
import software.amazon.smithy.ruby.codegen.util.Streaming;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
public class ClientGenerator
extends RubyGeneratorBase {
    private static final Logger LOGGER = Logger.getLogger(ClientGenerator.class.getName());
    private final Set<OperationShape> operations;
    private final MiddlewareBuilder middlewareBuilder;
    private final Set<RubyRuntimePlugin> runtimePlugins;
    private boolean hasOutputStreamingOperation = false;

    public ClientGenerator(GenerateServiceDirective<GenerationContext, RubySettings> directive, MiddlewareBuilder middlewareBuilder) {
        super((ContextualDirective<GenerationContext, RubySettings>)directive);
        this.operations = directive.operations();
        this.middlewareBuilder = middlewareBuilder;
        this.runtimePlugins = this.context.getRuntimePlugins();
        this.operations.forEach(operation -> {
            Shape outputShape = this.model.expectShape(operation.getOutputShape());
            if (Streaming.isStreaming(this.model, outputShape)) {
                this.hasOutputStreamingOperation = true;
            }
        });
    }

    @Override
    String getModule() {
        return "Client";
    }

    public void render() {
        List<String> additionalFiles = this.middlewareBuilder.writeAdditionalFiles(this.context);
        additionalFiles.addAll(this.runtimePlugins.stream().map(plugin -> plugin.writeAdditionalFiles(this.context)).flatMap(Collection::stream).distinct().sorted().collect(Collectors.toList()));
        additionalFiles.sort(String::compareTo);
        this.write(writer -> ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.preamble().includeRequires().writeRequireRelativeAdditionalFiles(additionalFiles).openBlock("module $L", new Object[]{this.settings.getModule()})).call(() -> new ShapeDocumentationGenerator(this.model, (RubyCodeWriter)((Object)writer), this.symbolProvider, (Shape)this.context.service()).render())).openBlock("class Client", new Object[0])).write("include $T", new Object[]{Hearth.CLIENT_STUBS})).write("", new Object[0])).call(() -> this.renderClassRuntimePlugins((RubyCodeWriter)((Object)writer)))).call(() -> this.renderInitializeMethod((RubyCodeWriter)((Object)writer)))).write("\n# @return [Config] config", new Object[0])).write("attr_reader :config\n", new Object[0])).call(() -> this.renderOperations((RubyCodeWriter)((Object)writer)))).write("\nprivate", new Object[0])).call(() -> this.renderInitializeConfigMethod((RubyCodeWriter)((Object)writer)))).call(() -> this.renderOperationConfigMethod((RubyCodeWriter)((Object)writer)))).call(() -> {
            if (this.hasOutputStreamingOperation) {
                this.renderOutputStreamMethod((RubyCodeWriter)((Object)writer));
            }
        })).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]));
        LOGGER.fine("Wrote client to " + this.rbFile());
    }

    public void renderRbs() {
        this.writeRbs(writer -> ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.preamble().openBlock("module $L", new Object[]{this.settings.getModule()})).openBlock("class Client", new Object[0])).write("include $T\n", new Object[]{Hearth.CLIENT_STUBS})).write("def self.plugins: () -> Hearth::PluginList\n", new Object[0])).write("def initialize: (?Config, ?::Hash[::Symbol, untyped] options) -> void\n", new Object[0])).write("attr_reader config: Config", new Object[0])).write("", new Object[0])).call(() -> this.renderRbsOperations((RubyCodeWriter)((Object)writer)))).closeBlock("end", new Object[0])).closeBlock("end", new Object[0]));
        LOGGER.fine("Wrote client rbs to " + this.rbsFile());
    }

    private void renderClassRuntimePlugins(RubyCodeWriter writer) {
        writer.apiPrivate();
        if (this.runtimePlugins.isEmpty()) {
            writer.write("@plugins = $T.new", new Object[]{Hearth.PLUGIN_LIST});
        } else {
            writer.openBlock("@plugins = $T.new([", new Object[]{Hearth.PLUGIN_LIST});
            writer.write(this.runtimePlugins.stream().map(p -> p.renderAdd(this.context)).collect(Collectors.joining(",\n")), new Object[0]);
            writer.closeBlock("])", new Object[0]);
        }
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.write("", new Object[0])).writeYardReturn("Hearth::PluginList", "").openBlock("def self.plugins", new Object[0])).write("@plugins", new Object[0])).closeBlock("end\n", new Object[0]);
    }

    private void renderInitializeMethod(RubyCodeWriter writer) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.writeYardParam("Hash", "options", "Options used to construct an instance of {Config}").openBlock("def initialize(options = {})", new Object[0])).write("@config = initialize_config(options)", new Object[0])).write("@stubs = $T.new", new Object[]{Hearth.STUBS})).closeBlock("end", new Object[0]);
    }

    private void renderOperations(RubyCodeWriter writer) {
        this.operations.stream().filter(o -> !Streaming.isEventStreaming(this.model, o)).sorted(Comparator.comparing(o -> o.getId().getName())).forEach(o -> this.renderOperation(writer, (OperationShape)o));
    }

    private void renderRbsOperations(RubyCodeWriter writer) {
        this.operations.stream().sorted(Comparator.comparing(o -> o.getId().getName())).forEach(o -> this.renderRbsOperation(writer, (OperationShape)o));
    }

    private void renderOperation(RubyCodeWriter writer, OperationShape operation) {
        Shape inputShape = this.model.expectShape(operation.getInputShape());
        Shape outputShape = this.model.expectShape(operation.getOutputShape());
        String operationName = RubyFormatter.toSnakeCase(this.symbolProvider.toSymbol((Shape)operation).getName());
        boolean isStreaming = Streaming.isStreaming(this.model, outputShape);
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.write("", new Object[0])).call(() -> new ShapeDocumentationGenerator(this.model, writer, this.symbolProvider, (Shape)operation).render())).call(() -> {
            if (isStreaming) {
                ((RubyCodeWriter)writer.openBlock("def $L(params = {}, options = {}, &block)", new Object[]{operationName})).write("response_body = output_stream(options, &block)", new Object[0]);
            } else {
                ((RubyCodeWriter)writer.openBlock("def $L(params = {}, options = {})", new Object[]{operationName})).write("response_body = $T.new", new Object[]{RubyImportContainer.STRING_IO});
            }
        })).write("config = operation_config(options)", new Object[0])).write("stack = $T.new", new Object[]{Hearth.MIDDLEWARE_STACK})).write("input = Params::$L.build(params, context: 'params')", new Object[]{this.symbolProvider.toSymbol(inputShape).getName()})).call(() -> this.middlewareBuilder.render(writer, this.context, operation))).openBlock("context = $T.new(", new Object[]{Hearth.CONTEXT})).write("request: $L,", new Object[]{this.context.applicationTransport().getRequest().render(this.context)})).write("response: $L,", new Object[]{this.context.applicationTransport().getResponse().render(this.context)})).write("logger: config.logger,", new Object[0])).write("operation_name: :$L,", new Object[]{operationName})).write("interceptors: config.interceptors", new Object[0])).closeBlock(")", new Object[0])).write("context.logger.info(\"[#{context.invocation_id}] [#{self.class}#$L] params: #{params}, options: #{options}\")", new Object[]{operationName})).write("output = stack.run(input, context)", new Object[0])).openBlock("if output.error", new Object[0])).write("context.logger.error(\"[#{context.invocation_id}] [#{self.class}#$L] #{output.error} (#{output.error.class})\")", new Object[]{operationName})).write("raise output.error", new Object[0])).closeBlock("end", new Object[0])).write("context.logger.info(\"[#{context.invocation_id}] [#{self.class}#$L] #{output.data}\")", new Object[]{operationName})).write("output", new Object[0])).closeBlock("end", new Object[0]);
        LOGGER.finer("Generated client operation method " + operationName);
    }

    private void renderRbsOperation(RubyCodeWriter writer, OperationShape operation) {
        String operationName = RubyFormatter.toSnakeCase(this.symbolProvider.toSymbol((Shape)operation).getName());
        Shape outputShape = this.model.expectShape(operation.getOutputShape());
        boolean isStreaming = outputShape.members().stream().anyMatch(m -> m.getMemberTrait(this.model, StreamingTrait.class).isPresent());
        writer.writeInline("def $L: (?::Hash[::Symbol, untyped] params, ?::Hash[::Symbol, untyped] options)", new Object[]{operationName});
        if (isStreaming) {
            writer.writeInline("?{ (::String) -> Hearth::BlockIO }", new Object[0]);
        }
        writer.write("-> Hearth::Output", new Object[0]);
    }

    private void renderInitializeConfigMethod(RubyCodeWriter writer) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("\ndef initialize_config(options)", new Object[0])).write("client_interceptors = options.delete(:interceptors)", new Object[0])).write("config = Config.new(**options)", new Object[0])).write("Client.plugins.each { |p| p.call(config) }", new Object[0])).write("config.plugins.each { |p| p.call(config) }", new Object[0])).write("config.interceptors.concat($T.new(client_interceptors)) if client_interceptors", new Object[]{Hearth.INTERCEPTOR_LIST})).write("config.validate!", new Object[0])).write("config.freeze", new Object[0])).closeBlock("end", new Object[0]);
    }

    private void renderOperationConfigMethod(RubyCodeWriter writer) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("\ndef operation_config(options)", new Object[0])).write("return @config if options.empty?", new Object[0])).write("", new Object[0])).write("operation_plugins = options.delete(:plugins)", new Object[0])).write("operation_interceptors = options.delete(:interceptors)", new Object[0])).write("config = @config.merge(options)", new Object[0])).write("$T.new(operation_plugins).each { |p| p.call(config) } if operation_plugins", new Object[]{Hearth.PLUGIN_LIST})).write("config.interceptors.concat($T.new(operation_interceptors)) if operation_interceptors", new Object[]{Hearth.INTERCEPTOR_LIST})).write("config.validate!", new Object[0])).write("config.freeze", new Object[0])).closeBlock("end", new Object[0]);
    }

    private void renderOutputStreamMethod(RubyCodeWriter writer) {
        ((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)((RubyCodeWriter)writer.openBlock("\ndef output_stream(options = {}, &block)", new Object[0])).write("return options.delete(:output_stream) if options[:output_stream]", new Object[0])).write("return $T.new(block) if block", new Object[]{Hearth.BLOCK_IO})).write("\n$T.new", new Object[]{RubyImportContainer.STRING_IO})).closeBlock("end", new Object[0]);
    }
}

