/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.auth.factories;

import software.amazon.smithy.model.traits.HttpBearerAuthTrait;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.auth.AuthScheme;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;

public final class HttpBearerAuthSchemeFactory {
    private HttpBearerAuthSchemeFactory() {
    }

    public static AuthScheme build() {
        String identityResolverDocumentation = "A %s that returns a %s for operations modeled with the %s auth scheme.\n";
        String defaultIdentity = Hearth.IDENTITIES + "::HTTPBearer.new(token: 'stubbed bearer')";
        String defaultConfigValue = "cfg[:stub_responses] ? %s.new(proc { %s }) : nil".formatted(Hearth.IDENTITY_RESOLVER, defaultIdentity);
        String identityType = Hearth.IDENTITIES + "::HTTPBearer";
        ClientConfig identityResolverConfig = ClientConfig.builder().name("http_bearer_identity_resolver").type(Hearth.IDENTITY_RESOLVER.toString()).documentation(identityResolverDocumentation.formatted(Hearth.IDENTITY_RESOLVER, identityType, HttpBearerAuthTrait.ID)).defaultDynamicValue(defaultConfigValue).build();
        return AuthScheme.builder().shapeId(HttpBearerAuthTrait.ID).rubyAuthScheme(Hearth.AUTH_SCHEMES + "::HTTPBearer.new").rubyIdentityType(identityType).identityResolverConfig(identityResolverConfig).build();
    }
}

