/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.ruby.codegen.auth.factories;

import java.util.HashMap;
import software.amazon.smithy.model.traits.HttpApiKeyAuthTrait;
import software.amazon.smithy.ruby.codegen.Hearth;
import software.amazon.smithy.ruby.codegen.auth.AuthScheme;
import software.amazon.smithy.ruby.codegen.config.ClientConfig;

public final class HttpApiKeyAuthSchemeFactory {
    private HttpApiKeyAuthSchemeFactory() {
    }

    public static AuthScheme build() {
        String identityResolverDocumentation = "A %s that returns a %s for operations modeled with the %s auth scheme.\n";
        String defaultIdentity = Hearth.IDENTITIES + "::HTTPApiKey.new(key: 'stubbed api key')";
        String defaultConfigValue = "cfg[:stub_responses] ? %s.new(proc { %s }) : nil".formatted(Hearth.IDENTITY_RESOLVER, defaultIdentity);
        String identityType = Hearth.IDENTITIES + "::HTTPApiKey";
        ClientConfig identityResolverConfig = ClientConfig.builder().name("http_api_key_identity_resolver").type(Hearth.IDENTITY_RESOLVER.toString()).documentation(identityResolverDocumentation.formatted(Hearth.IDENTITY_RESOLVER, identityType, HttpApiKeyAuthTrait.ID)).defaultDynamicValue(defaultConfigValue).build();
        return AuthScheme.builder().shapeId(HttpApiKeyAuthTrait.ID).rubyAuthScheme(Hearth.AUTH_SCHEMES + "::HTTPApiKey.new").rubyIdentityType(identityType).identityResolverConfig(identityResolverConfig).extractSignerProperties(trait -> {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("in", "'%s'".formatted(((HttpApiKeyAuthTrait)trait).getIn().toString()));
            properties.put("name", "'%s'".formatted(((HttpApiKeyAuthTrait)trait).getName()));
            if (((HttpApiKeyAuthTrait)trait).getScheme().isPresent()) {
                properties.put("scheme", "'%s'".formatted(((HttpApiKeyAuthTrait)trait).getScheme().get()));
            }
            return properties;
        }).build();
    }
}

