/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.endpoints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.aws.traits.ServiceTrait;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.core.CodegenContext;
import software.amazon.smithy.kotlin.codegen.core.KotlinDelegator;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.integration.AuthSchemeHandler;
import software.amazon.smithy.kotlin.codegen.integration.KotlinIntegration;
import software.amazon.smithy.kotlin.codegen.integration.SectionWriterBinding;
import software.amazon.smithy.kotlin.codegen.model.RulesEngineExtKt;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.model.SymbolExtKt;
import software.amazon.smithy.kotlin.codegen.rendering.endpoints.EndpointCustomization;
import software.amazon.smithy.kotlin.codegen.rendering.endpoints.ExpressionRenderer;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolMiddleware;
import software.amazon.smithy.kotlin.codegen.rendering.util.ConfigProperty;
import software.amazon.smithy.kotlin.codegen.rendering.util.ConfigPropertyType;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.rulesengine.language.EndpointRuleSet;
import software.amazon.smithy.rulesengine.language.syntax.expressions.Expression;
import software.amazon.smithy.rulesengine.language.syntax.parameters.Parameter;
import software.amazon.smithy.rulesengine.language.syntax.parameters.Parameters;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/endpoints/SdkEndpointBuiltinIntegration;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/KotlinIntegration;", "<init>", "()V", "enabledForService", "", "model", "Lsoftware/amazon/smithy/model/Model;", "settings", "Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;", "additionalServiceConfigProps", "", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/util/ConfigProperty;", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/core/CodegenContext;", "customizeEndpointResolution", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/endpoints/EndpointCustomization;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "Companion", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nSdkEndpointBuiltinIntegration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkEndpointBuiltinIntegration.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/endpoints/SdkEndpointBuiltinIntegration\n+ 2 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n43#2:70\n73#2:71\n1#3:72\n*S KotlinDebug\n*F\n+ 1 SdkEndpointBuiltinIntegration.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/endpoints/SdkEndpointBuiltinIntegration\n*L\n46#1:70\n47#1:71\n*E\n"})
public final class SdkEndpointBuiltinIntegration
implements KotlinIntegration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String BUILTIN_NAME = "SDK::Endpoint";
    @NotNull
    private static final ConfigProperty EndpointUrlProp = ConfigProperty.Companion.invoke((Function1<? super ConfigProperty.Builder, Unit>)((Function1)SdkEndpointBuiltinIntegration::EndpointUrlProp$lambda$1));

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean enabledForService(@NotNull Model model, @NotNull KotlinSettings settings) {
        Object v4;
        block1: {
            void $this$expectShape$iv;
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Model model2 = model;
            ShapeId shapeId$iv = settings.getService();
            boolean $i$f$expectShape = false;
            Shape shape = $this$expectShape$iv.expectShape(shapeId$iv, ServiceShape.class);
            Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"expectShape(...)");
            ServiceShape service = (ServiceShape)shape;
            Shape $this$hasTrait$iv = (Shape)service;
            boolean $i$f$hasTrait = false;
            boolean isAwsSdk = $this$hasTrait$iv.hasTrait(ServiceTrait.class);
            if (isAwsSdk) return true;
            EndpointRuleSet endpointRuleSet = ShapeExtKt.getEndpointRules(service);
            EndpointRuleSet endpointRuleSet2 = endpointRuleSet;
            if (endpointRuleSet == null) return false;
            Parameters parameters = endpointRuleSet2.getParameters();
            endpointRuleSet2 = parameters;
            if (parameters == null) return false;
            Iterable iterable = (Iterable)endpointRuleSet2;
            for (Object t : iterable) {
                Parameter it = (Parameter)t;
                boolean bl = false;
                if (!(it.isBuiltIn() && Intrinsics.areEqual(it.getBuiltIn().get(), (Object)BUILTIN_NAME))) continue;
                v4 = t;
                break block1;
            }
            v4 = null;
        }
        Parameter parameter = v4;
        if (parameter == null) return false;
        return true;
    }

    @Override
    @NotNull
    public List<ConfigProperty> additionalServiceConfigProps(@NotNull CodegenContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return CollectionsKt.listOf((Object)EndpointUrlProp);
    }

    @Override
    @NotNull
    public EndpointCustomization customizeEndpointResolution(@NotNull ProtocolGenerator.GenerationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return new EndpointCustomization(){

            /*
             * WARNING - void declaration
             */
            public void renderBindEndpointBuiltins(ProtocolGenerator.GenerationContext ctx, EndpointRuleSet rules, KotlinWriter writer) {
                Collection destination$iv$iv;
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)rules, (String)"rules");
                Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
                Object object = rules.getParameters();
                if (object != null && (object = CollectionsKt.toList((Iterable)((Iterable)object))) != null) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = (Iterable)object;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        Parameter p0 = (Parameter)element$iv$iv;
                        boolean bl = false;
                        if (!p0.isBuiltIn()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                } else {
                    return;
                }
                List builtins = (List)destination$iv$iv;
                Iterable $this$forEach$iv = builtins;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Parameter it = (Parameter)element$iv;
                    boolean bl = false;
                    String string = (String)it.getBuiltIn().get();
                    switch (string.hashCode()) {
                        case 1517400207: {
                            if (!string.equals("SDK::Endpoint")) break;
                            Object[] objectArray = new Object[2];
                            Intrinsics.checkNotNull((Object)it);
                            objectArray[0] = RulesEngineExtKt.defaultName(it);
                            objectArray[1] = SdkEndpointBuiltinIntegration.Companion.getEndpointUrlProp().getPropertyName();
                            writer.write("#L = config.#L?.toString()", objectArray);
                        }
                    }
                }
            }

            public Map<String, Symbol> getExternalFunctions() {
                return EndpointCustomization.super.getExternalFunctions();
            }

            public Map<String, Function3<KotlinWriter, Expression, ExpressionRenderer, Unit>> getPropertyRenderers() {
                return EndpointCustomization.super.getPropertyRenderers();
            }
        };
    }

    @Override
    public byte getOrder() {
        return KotlinIntegration.super.getOrder();
    }

    @Override
    @NotNull
    public List<ProtocolGenerator> getProtocolGenerators() {
        return KotlinIntegration.super.getProtocolGenerators();
    }

    @Override
    @NotNull
    public List<SectionWriterBinding> getSectionWriters() {
        return KotlinIntegration.super.getSectionWriters();
    }

    @Override
    @NotNull
    public Model preprocessModel(@NotNull Model model, @NotNull KotlinSettings settings) {
        return KotlinIntegration.super.preprocessModel(model, settings);
    }

    @Override
    @NotNull
    public SymbolProvider decorateSymbolProvider(@NotNull KotlinSettings settings, @NotNull Model model, @NotNull SymbolProvider symbolProvider) {
        return KotlinIntegration.super.decorateSymbolProvider(settings, model, symbolProvider);
    }

    @Override
    public void writeAdditionalFiles(@NotNull CodegenContext ctx, @NotNull KotlinDelegator delegator) {
        KotlinIntegration.super.writeAdditionalFiles(ctx, delegator);
    }

    @Override
    @NotNull
    public List<ProtocolMiddleware> customizeMiddleware(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull List<? extends ProtocolMiddleware> resolved) {
        return KotlinIntegration.super.customizeMiddleware(ctx, resolved);
    }

    @Override
    @NotNull
    public List<AuthSchemeHandler> authSchemes(@NotNull ProtocolGenerator.GenerationContext ctx) {
        return KotlinIntegration.super.authSchemes(ctx);
    }

    private static final Unit EndpointUrlProp$lambda$1(ConfigProperty.Builder $this$ConfigProperty) {
        Intrinsics.checkNotNullParameter((Object)$this$ConfigProperty, (String)"$this$ConfigProperty");
        $this$ConfigProperty.setName("endpointUrl");
        $this$ConfigProperty.setSymbol(SymbolExtKt.asNullable(RuntimeTypes.Core.Net.Url.INSTANCE.getUrl()));
        $this$ConfigProperty.setDocumentation("A custom endpoint to route requests to. The endpoint set here is passed to the configured\n[endpointProvider], which may inspect and modify it as needed.\n\nSetting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is\nthe recommended way to route requests to development or preview instances of a service.\n\n**This is an advanced config option.**");
        $this$ConfigProperty.setPropertyType(ConfigPropertyType.SymbolDefault.INSTANCE);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/endpoints/SdkEndpointBuiltinIntegration$Companion;", "", "<init>", "()V", "BUILTIN_NAME", "", "EndpointUrlProp", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/util/ConfigProperty;", "getEndpointUrlProp", "()Lsoftware/amazon/smithy/kotlin/codegen/rendering/util/ConfigProperty;", "smithy-kotlin-codegen"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConfigProperty getEndpointUrlProp() {
            return EndpointUrlProp;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

