/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.aws.traits.protocols.AwsJson1_0Trait;
import software.amazon.smithy.aws.traits.protocols.AwsJson1_1Trait;
import software.amazon.smithy.aws.traits.protocols.AwsQueryTrait;
import software.amazon.smithy.aws.traits.protocols.Ec2QueryTrait;
import software.amazon.smithy.aws.traits.protocols.RestJson1Trait;
import software.amazon.smithy.aws.traits.protocols.RestXmlTrait;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.kotlin.codegen.KotlinSettingsKt;
import software.amazon.smithy.kotlin.codegen.utils.CaseUtilsKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NullableIndex;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.protocol.traits.Rpcv2CborTrait;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\n\u0010\f\u001a\u00020\u000b*\u00020\r\u001a\u001f\u0010\u000e\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0015\u001a\u00020\u0001*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"SERVICE", "", "PACKAGE_SETTINGS", "PACKAGE_NAME", "PACKAGE_VERSION", "PACKAGE_DESCRIPTION", "BUILD_SETTINGS", "API_SETTINGS", "SDK_ID", "DEFAULT_PROTOCOL_RESOLUTION_PRIORITY", "", "Lsoftware/amazon/smithy/model/shapes/ShapeId;", "inferService", "Lsoftware/amazon/smithy/model/Model;", "orNull", "T", "Ljava/util/Optional;", "(Ljava/util/Optional;)Ljava/lang/Object;", "checkModefromValue", "Lsoftware/amazon/smithy/model/knowledge/NullableIndex$CheckMode;", "value", "kotlinPluginSetting", "getKotlinPluginSetting", "(Lsoftware/amazon/smithy/model/knowledge/NullableIndex$CheckMode;)Ljava/lang/String;", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nKotlinSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSettings.kt\nsoftware/amazon/smithy/kotlin/codegen/KotlinSettingsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,338:1\n8634#2,2:339\n8894#2,4:341\n1#3:345\n*S KotlinDebug\n*F\n+ 1 KotlinSettings.kt\nsoftware/amazon/smithy/kotlin/codegen/KotlinSettingsKt\n*L\n252#1:339,2\n252#1:341,4\n*E\n"})
public final class KotlinSettingsKt {
    @NotNull
    private static final String SERVICE = "service";
    @NotNull
    private static final String PACKAGE_SETTINGS = "package";
    @NotNull
    private static final String PACKAGE_NAME = "name";
    @NotNull
    private static final String PACKAGE_VERSION = "version";
    @NotNull
    private static final String PACKAGE_DESCRIPTION = "description";
    @NotNull
    private static final String BUILD_SETTINGS = "build";
    @NotNull
    private static final String API_SETTINGS = "api";
    @NotNull
    private static final String SDK_ID = "sdkId";
    @NotNull
    private static final Set<ShapeId> DEFAULT_PROTOCOL_RESOLUTION_PRIORITY;

    @NotNull
    public static final ShapeId inferService(@NotNull Model $this$inferService) {
        Intrinsics.checkNotNullParameter((Object)$this$inferService, (String)"<this>");
        Stream<ShapeId> stream = $this$inferService.shapes(ServiceShape.class).map(arg_0 -> KotlinSettingsKt.inferService$lambda$0(inferService.services.1.INSTANCE, arg_0)).sorted();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"sorted(...)");
        List services2 = StreamsKt.toList(stream);
        if (services2.isEmpty()) {
            throw new CodegenException("Cannot infer a service to generate because the model does not contain any service shapes");
        }
        if (services2.size() > 1) {
            throw new CodegenException("Cannot infer service to generate because the model contains multiple service shapes: " + services2);
        }
        Object object = CollectionsKt.single((List)services2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"single(...)");
        return (ShapeId)object;
    }

    private static final <T> T orNull(Optional<T> $this$orNull) {
        return $this$orNull.isPresent() ? (T)$this$orNull.get() : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final NullableIndex.CheckMode checkModefromValue(String value) {
        void $this$associateByTo$iv$iv;
        NullableIndex.CheckMode[] $this$associateBy$iv = NullableIndex.CheckMode.values();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        NullableIndex.CheckMode[] checkModeArray = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        int n = ((void)$this$associateByTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv$iv;
            void var11_11 = element$iv$iv = $this$associateByTo$iv$iv[i];
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(CaseUtilsKt.toCamelCase(it.toString()), element$iv$iv);
        }
        Map camelCaseToMode = destination$iv$iv;
        Object v = camelCaseToMode.get(value);
        if (v == null) {
            boolean bl = false;
            String string = value + " is not a valid CheckMode, expected one of " + camelCaseToMode.keySet();
            throw new IllegalArgumentException(string.toString());
        }
        return (NullableIndex.CheckMode)v;
    }

    @NotNull
    public static final String getKotlinPluginSetting(@NotNull NullableIndex.CheckMode $this$kotlinPluginSetting) {
        Intrinsics.checkNotNullParameter((Object)$this$kotlinPluginSetting, (String)"<this>");
        return CaseUtilsKt.toCamelCase($this$kotlinPluginSetting.toString());
    }

    private static final ShapeId inferService$lambda$0(Function1 $tmp0, Object p0) {
        return (ShapeId)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Object access$orNull(Optional $receiver) {
        return KotlinSettingsKt.orNull($receiver);
    }

    public static final /* synthetic */ Set access$getDEFAULT_PROTOCOL_RESOLUTION_PRIORITY$p() {
        return DEFAULT_PROTOCOL_RESOLUTION_PRIORITY;
    }

    public static final /* synthetic */ NullableIndex.CheckMode access$checkModefromValue(String value) {
        return KotlinSettingsKt.checkModefromValue(value);
    }

    static {
        Object[] objectArray = new ShapeId[]{Rpcv2CborTrait.ID, AwsJson1_0Trait.ID, AwsJson1_1Trait.ID, RestJson1Trait.ID, RestXmlTrait.ID, AwsQueryTrait.ID, Ec2QueryTrait.ID};
        DEFAULT_PROTOCOL_RESOLUTION_PRIORITY = SetsKt.setOf((Object[])objectArray);
    }
}

