/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.core.CodegenContext;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.model.SymbolExtKt;
import software.amazon.smithy.kotlin.codegen.rendering.ItemDescriptor;
import software.amazon.smithy.model.knowledge.PaginationInfo;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"getItemDescriptorOrNull", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/ItemDescriptor;", "paginationInfo", "Lsoftware/amazon/smithy/model/knowledge/PaginationInfo;", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/core/CodegenContext;", "smithy-kotlin-codegen"})
public final class PaginatorGeneratorKt {
    private static final ItemDescriptor getItemDescriptorOrNull(PaginationInfo paginationInfo, CodegenContext ctx) {
        Pair pair;
        List list = paginationInfo.getItemsMemberPath();
        if (list == null || (list = (MemberShape)CollectionsKt.lastOrNull((List)list)) == null || (list = list.getTarget()) == null) {
            return null;
        }
        List itemMemberId = list;
        List list2 = paginationInfo.getItemsMemberPath();
        Intrinsics.checkNotNull((Object)list2);
        Object object = CollectionsKt.last((List)list2);
        Intrinsics.checkNotNull((Object)object);
        String itemLiteral = NamingKt.defaultName((MemberShape)object);
        List list3 = paginationInfo.getItemsMemberPath();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getItemsMemberPath(...)");
        String itemPathLiteral = CollectionsKt.joinToString$default((Iterable)list3, (CharSequence)"?.", null, null, (int)0, null, PaginatorGeneratorKt::getItemDescriptorOrNull$lambda$0, (int)30, null);
        Shape itemMember = ctx.getModel().expectShape((ShapeId)itemMemberId);
        Intrinsics.checkNotNull((Object)itemMember);
        boolean isSparse = ShapeExtKt.isSparse(itemMember);
        Shape shape = itemMember;
        if (shape instanceof MapShape) {
            Symbol symbol = ctx.getSymbolProvider().toSymbol(itemMember);
            Object object2 = symbol.expectProperty("entryExpression");
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
            String entryExpression = (String)object2;
            pair = TuplesKt.to((Object)entryExpression, (Object)itemMember);
        } else if (shape instanceof CollectionShape) {
            Shape target = ctx.getModel().expectShape(((CollectionShape)itemMember).getMember().getTarget());
            Symbol symbol = ctx.getSymbolProvider().toSymbol(target);
            StringBuilder stringBuilder = new StringBuilder().append(symbol.getName());
            Intrinsics.checkNotNull((Object)symbol);
            String literal = stringBuilder.append(SymbolExtKt.isNullable(symbol) || isSparse ? "?" : "").toString();
            pair = TuplesKt.to((Object)literal, (Object)target);
        } else {
            throw new IllegalStateException(("Unexpected shape type " + itemMember.getType()).toString());
        }
        Pair pair2 = pair;
        String collectionLiteral = (String)pair2.component1();
        Shape targetMember = (Shape)pair2.component2();
        Intrinsics.checkNotNull((Object)targetMember);
        Symbol symbol = ctx.getSymbolProvider().toSymbol(itemMember);
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"toSymbol(...)");
        return new ItemDescriptor(collectionLiteral, targetMember, itemLiteral, itemPathLiteral, symbol);
    }

    private static final CharSequence getItemDescriptorOrNull$lambda$0(MemberShape it) {
        Intrinsics.checkNotNull((Object)it);
        return NamingKt.defaultName(it);
    }

    public static final /* synthetic */ ItemDescriptor access$getItemDescriptorOrNull(PaginationInfo paginationInfo, CodegenContext ctx) {
        return PaginatorGeneratorKt.getItemDescriptorOrNull(paginationInfo, ctx);
    }
}

