/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.s3accessgrants.plugin;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.NotNull;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.s3accessgrants.cache.S3AccessGrantsCachedBucketRegionResolver;
import software.amazon.awssdk.s3accessgrants.plugin.internal.S3AccessGrantsOperationToPermissionMapper;
import software.amazon.awssdk.s3accessgrants.plugin.internal.S3AccessGrantsStaticOperationToPermissionMapper;
import software.amazon.awssdk.s3accessgrants.plugin.internal.S3AccessGrantsUtils;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.auth.scheme.S3AuthSchemeParams;
import software.amazon.awssdk.services.s3.auth.scheme.S3AuthSchemeProvider;
import software.amazon.awssdk.services.s3control.model.Permission;

public class S3AccessGrantsAuthSchemeProvider
implements S3AuthSchemeProvider {
    private final S3AuthSchemeProvider authSchemeProvider;
    private final S3Client s3Client;
    private final Boolean isCrossRegionAccessEnabled;
    private final S3AccessGrantsOperationToPermissionMapper permissionMapper;
    private final S3AccessGrantsCachedBucketRegionResolver bucketRegionCache;

    S3AccessGrantsAuthSchemeProvider(@NotNull S3AuthSchemeProvider authSchemeProvider, S3Client s3Client, Boolean isCrossRegionAccessEnabled) {
        S3AccessGrantsUtils.argumentNotNull(authSchemeProvider, "Expecting an Auth Scheme Provider to be specified while configuring S3Clients!");
        S3AccessGrantsUtils.argumentNotNull(s3Client, String.format(S3AccessGrantsUtils.CONTACT_TEAM_MESSAGE_TEMPLATE, "S3 Client", "Plugin"));
        this.authSchemeProvider = authSchemeProvider;
        this.s3Client = s3Client;
        this.isCrossRegionAccessEnabled = isCrossRegionAccessEnabled == null ? S3AccessGrantsUtils.DEFAULT_CROSS_REGION_ACCESS_SETTING : isCrossRegionAccessEnabled;
        this.permissionMapper = new S3AccessGrantsStaticOperationToPermissionMapper();
        this.bucketRegionCache = S3AccessGrantsCachedBucketRegionResolver.builder().s3Client(s3Client).build();
    }

    public List<AuthSchemeOption> resolveAuthScheme(@NotNull S3AuthSchemeParams authSchemeParams) {
        S3AccessGrantsUtils.argumentNotNull(authSchemeParams, "An internal exception has occurred. Valid auth scheme params were not passed to the Auth Scheme Provider. Please contact the S3 Access Grants plugin team!");
        List availableAuthSchemes = this.authSchemeProvider.resolveAuthScheme(authSchemeParams);
        try {
            S3AccessGrantsUtils.logger.debug(() -> "operation : " + authSchemeParams.operation());
            Permission permission = this.permissionMapper.getPermission(authSchemeParams.operation());
            S3AccessGrantsUtils.argumentNotNull(authSchemeParams.bucket(), "Please specify a valid bucket name for the operation!");
            Region destinationRegion = this.getBucketLocation(authSchemeParams.bucket());
            S3AccessGrantsUtils.logger.debug(() -> "Access Grants requests will be sent to the region " + destinationRegion);
            String S3Prefix = "s3://" + authSchemeParams.bucket() + "/" + this.getKeyIfExists(authSchemeParams);
            return availableAuthSchemes.stream().map(authScheme -> (AuthSchemeOption)((AuthSchemeOption.Builder)authScheme.toBuilder()).putIdentityProperty(S3AccessGrantsUtils.PREFIX_PROPERTY, (Object)S3Prefix).putIdentityProperty(S3AccessGrantsUtils.BUCKET_LOCATION_PROPERTY, (Object)destinationRegion).putIdentityProperty(S3AccessGrantsUtils.PERMISSION_PROPERTY, (Object)permission).build()).collect(Collectors.toList());
        }
        catch (SdkServiceException e) {
            return availableAuthSchemes.stream().map(authScheme -> (AuthSchemeOption)((AuthSchemeOption.Builder)authScheme.toBuilder()).putIdentityProperty(S3AccessGrantsUtils.AUTH_EXCEPTIONS_PROPERTY, (Object)e).build()).collect(Collectors.toList());
        }
    }

    private String getKeyIfExists(S3AuthSchemeParams authSchemeParams) {
        String validKey;
        Boolean keyDoesNotExists = !(authSchemeParams.key() != null && !authSchemeParams.key().isEmpty() || authSchemeParams.prefix() != null && !authSchemeParams.prefix().isEmpty());
        String string = authSchemeParams.key() != null && !authSchemeParams.key().isEmpty() ? authSchemeParams.key() : (validKey = authSchemeParams.prefix() != null && !authSchemeParams.prefix().isEmpty() ? authSchemeParams.prefix() : null);
        if (keyDoesNotExists.booleanValue()) {
            S3AccessGrantsUtils.logger.debug(() -> "no object key was specified for the operation!");
        }
        return keyDoesNotExists != false ? "*" : validKey;
    }

    private Region getBucketLocation(String bucketName) {
        if (this.isCrossRegionAccessEnabled.booleanValue()) {
            return this.bucketRegionCache.resolve(bucketName);
        }
        S3AccessGrantsUtils.argumentNotNull(this.s3Client.serviceClientConfiguration().region(), "Expecting a region to be configured on the S3Clients!");
        return this.s3Client.serviceClientConfiguration().region();
    }
}

