/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import software.amazon.awssdk.utils.Validate;
import software.amazon.qldb.BackoffStrategy;
import software.amazon.qldb.DefaultQldbTransactionBackoffStrategy;

public final class RetryPolicy {
    private int maxRetries;
    private BackoffStrategy backoffStrategy;

    RetryPolicy(BackoffStrategy backoffStrategy, int maxRetries) {
        Validate.notNull((Object)backoffStrategy, (String)"backoffStrategy", (Object[])new Object[0]);
        this.backoffStrategy = backoffStrategy;
        this.maxRetries = maxRetries;
    }

    int maxRetries() {
        return this.maxRetries;
    }

    BackoffStrategy backoffStrategy() {
        return this.backoffStrategy;
    }

    public static RetryPolicy none() {
        return RetryPolicy.builder().maxRetries(0).backoffStrategy(new DefaultQldbTransactionBackoffStrategy()).build();
    }

    public static RetryPolicy maxRetries(int maxRetries) {
        return RetryPolicy.builder().maxRetries(maxRetries).backoffStrategy(new DefaultQldbTransactionBackoffStrategy()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        public static final int DEFAULT_RETRY_LIMIT = 4;
        private BackoffStrategy backoffStrategy = new DefaultQldbTransactionBackoffStrategy();
        private int maxRetries = 4;

        private Builder() {
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder backoffStrategy(BackoffStrategy backoffStrategy) {
            Validate.notNull((Object)backoffStrategy, (String)"backoffStrategy", (Object[])new Object[0]);
            this.backoffStrategy = backoffStrategy;
            return this;
        }

        public RetryPolicy build() {
            return new RetryPolicy(this.backoffStrategy, this.maxRetries);
        }
    }
}

