/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import com.amazonaws.services.qldbsession.model.Page;
import com.amazonaws.services.qldbsession.model.ValueHolder;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.qldb.ResultHolder;
import software.amazon.qldb.Session;
import software.amazon.qldb.Validate;
import software.amazon.qldb.exceptions.Errors;
import software.amazon.qldb.exceptions.QldbClientException;

class ResultRetriever {
    private static final Logger logger = LoggerFactory.getLogger(ResultRetriever.class);
    private final Session session;
    private Page currentPage;
    private int currentResultValueIndex;
    private final Retriever retriever;
    private final IonSystem ionSystem;
    private final ExecutorService executorService;
    private final AtomicBoolean isClosed;

    ResultRetriever(Session session, Page firstPage, String txnId, int readAhead, IonSystem ionSystem, ExecutorService executorService) {
        Validate.assertIsNotNegative(readAhead, "readAhead");
        this.session = session;
        this.currentPage = firstPage;
        this.currentResultValueIndex = 0;
        this.ionSystem = ionSystem;
        this.executorService = executorService;
        this.isClosed = new AtomicBoolean(false);
        if (this.currentPage.getNextPageToken() == null) {
            this.retriever = null;
        } else if (0 == readAhead) {
            this.retriever = new Retriever(session, txnId, this.currentPage.getNextPageToken());
        } else {
            ResultRetrieverRunnable runner = new ResultRetrieverRunnable(session, txnId, this.currentPage.getNextPageToken(), readAhead, this.isClosed);
            this.retriever = runner;
            if (null == executorService) {
                Thread retrieverThread = new Thread((Runnable)runner, "ResultRetriever");
                retrieverThread.setDaemon(true);
                retrieverThread.start();
            } else {
                this.executorService.submit(runner);
            }
        }
    }

    public synchronized boolean hasNext() {
        if (this.isClosed.get()) {
            throw QldbClientException.create(Errors.RESULT_PARENT_INACTIVE.get(), this.session.getToken(), logger);
        }
        while (this.currentResultValueIndex >= this.currentPage.getValues().size()) {
            if (null == this.currentPage.getNextPageToken()) {
                return false;
            }
            this.currentPage = this.retriever.getNextPage();
            this.currentResultValueIndex = 0;
        }
        return true;
    }

    public synchronized IonValue next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ByteBuffer bytes = ((ValueHolder)this.currentPage.getValues().get(this.currentResultValueIndex++)).getIonBinary();
        return this.ionSystem.singleValue(bytes.array());
    }

    void close() {
        this.isClosed.set(true);
    }

    private static class ResultRetrieverRunnable
    extends Retriever
    implements Runnable {
        private final BlockingDeque<ResultHolder<Exception>> results;
        private final int readAhead;
        private final AtomicBoolean isClosed;

        ResultRetrieverRunnable(Session session, String txnId, String nextPageToken, int readAhead, AtomicBoolean isClosed) {
            super(session, txnId, nextPageToken);
            this.readAhead = Math.min(1, readAhead - 1);
            this.results = new LinkedBlockingDeque<ResultHolder<Exception>>(readAhead);
            this.isClosed = isClosed;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                while (null != this.nextPageToken) {
                    Page page = super.getNextPage();
                    try {
                        while (!this.results.offer(new ResultHolder(page), 50L, TimeUnit.MILLISECONDS)) {
                            if (this.isClosed.get()) {
                                throw QldbClientException.create(Errors.RESULT_PARENT_INACTIVE.get(), this.session.getToken(), logger);
                            }
                            Thread.yield();
                        }
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw QldbClientException.create(Errors.RETRIEVE_INTERRUPTED.get(), this.session.getToken(), ie, logger);
                        return;
                    }
                }
            }
            catch (Exception e) {
                this.results.clear();
                if (this.results.offerFirst(new ResultHolder<Exception>(e))) return;
                logger.error(String.format(Errors.QUEUE_CAPACITY.get(), this.readAhead), (Throwable)e);
            }
        }

        @Override
        Page getNextPage() {
            try {
                ResultHolder<Exception> result = this.results.take();
                if (null != result.getAssociatedValue()) {
                    if (result.getAssociatedValue() instanceof RuntimeException) {
                        throw (RuntimeException)result.getAssociatedValue();
                    }
                    throw new RuntimeException(result.getAssociatedValue());
                }
                return result.getResult();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw QldbClientException.create(Errors.RETRIEVE_INTERRUPTED.get(), this.session.getToken(), ie, logger);
            }
        }
    }

    private static class Retriever {
        final Session session;
        String nextPageToken;
        private final String txnId;

        private Retriever(Session session, String txnId, String nextPageToken) {
            this.session = session;
            this.txnId = txnId;
            this.nextPageToken = nextPageToken;
        }

        Page getNextPage() {
            Page result = this.session.sendFetchPage(this.txnId, this.nextPageToken).getPage();
            this.nextPageToken = result.getNextPageToken();
            return result;
        }
    }
}

