/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonSystem;
import com.amazon.ion.system.IonSystemBuilder;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.services.qldbsession.AmazonQLDBSession;
import com.amazonaws.services.qldbsession.AmazonQLDBSessionClientBuilder;
import com.amazonaws.util.ValidationUtils;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import software.amazon.qldb.Validate;

abstract class BaseQldbDriverBuilder<Subclass extends BaseQldbDriverBuilder, TypeToBuild> {
    private static final String VERSION_KEY = "project.version";
    private static final int DEFAULT_RETRY_LIMIT = 4;
    private static final IonSystem DEFAULT_ION_SYSTEM = IonSystemBuilder.standard().build();
    int clientMaxConnections;
    AmazonQLDBSession client;
    String ledgerName;
    int retryLimit = 4;
    IonSystem ionSystem = DEFAULT_ION_SYSTEM;

    BaseQldbDriverBuilder() {
    }

    public TypeToBuild build() {
        ValidationUtils.assertStringNotEmpty((String)this.ledgerName, (String)"ledgerName");
        ValidationUtils.assertNotNull((Object)this.client, (String)"client");
        return this.createDriver();
    }

    public Subclass withIonSystem(IonSystem ionSystem) {
        ValidationUtils.assertNotNull((Object)ionSystem, (String)"ionSystem");
        this.ionSystem = ionSystem;
        return this.getSubclass();
    }

    public Subclass withLedger(String ledgerName) {
        ValidationUtils.assertStringNotEmpty((String)ledgerName, (String)"ledgerName");
        this.ledgerName = ledgerName;
        return this.getSubclass();
    }

    public Subclass withRetryLimit(int retryLimit) {
        Validate.assertIsNotNegative(retryLimit, "retryLimit");
        this.retryLimit = retryLimit;
        return this.getSubclass();
    }

    public Subclass withSessionClientBuilder(AmazonQLDBSessionClientBuilder clientBuilder) {
        String version;
        ValidationUtils.assertNotNull((Object)clientBuilder, (String)"clientBuilder");
        try {
            version = this.getVersion() + ResourceBundle.getBundle("version").getString(VERSION_KEY);
        }
        catch (MissingResourceException e) {
            version = this.getVersion() + "unknown";
        }
        if (null == clientBuilder.getClientConfiguration()) {
            clientBuilder.setClientConfiguration(new ClientConfigurationFactory().getConfig());
        }
        clientBuilder.getClientConfiguration().setUserAgentSuffix(version);
        clientBuilder.getClientConfiguration().setMaxErrorRetry(0);
        this.clientMaxConnections = clientBuilder.getClientConfiguration().getMaxConnections();
        this.client = (AmazonQLDBSession)clientBuilder.build();
        return this.getSubclass();
    }

    protected abstract TypeToBuild createDriver();

    protected Subclass getSubclass() {
        return (Subclass)this;
    }

    protected abstract String getVersion();
}

