/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.services.qldbsession.model.Page;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.qldb.BaseResult;
import software.amazon.qldb.Result;
import software.amazon.qldb.ResultRetriever;
import software.amazon.qldb.Session;
import software.amazon.qldb.Validate;
import software.amazon.qldb.exceptions.Errors;

@NotThreadSafe
class StreamResult
extends BaseResult
implements Result {
    private static final Logger logger = LoggerFactory.getLogger(StreamResult.class);
    private final AtomicBoolean isRetrieved = new AtomicBoolean(false);
    private final IonIterator childItr;
    private final boolean isEmpty;

    public StreamResult(Session session, Page firstPage, String txnId, int readAheadBufferCount, IonSystem ionSystem, ExecutorService executorService) {
        super(session, txnId, ionSystem);
        this.childItr = new IonIterator(session, firstPage, txnId, readAheadBufferCount, ionSystem, executorService);
        this.isEmpty = !this.childItr.hasNext();
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public Iterator<IonValue> iterator() {
        if (this.isRetrieved.getAndSet(true)) {
            logger.error(Errors.STREAM_RESULT_ITERATED.get());
            throw new IllegalStateException(Errors.STREAM_RESULT_ITERATED.get());
        }
        return this.childItr;
    }

    void close() {
        this.childItr.close();
    }

    private static class IonIterator
    implements Iterator<IonValue> {
        private final ResultRetriever retriever;

        IonIterator(Session session, Page firstPage, String txnId, int readAhead, IonSystem ionSystem, ExecutorService executorService) {
            Validate.assertIsNotNegative(readAhead, "readAhead");
            this.retriever = new ResultRetriever(session, firstPage, txnId, readAhead, ionSystem, executorService);
        }

        @Override
        public boolean hasNext() {
            return this.retriever.hasNext();
        }

        @Override
        public IonValue next() {
            return this.retriever.next();
        }

        void close() {
            this.retriever.close();
        }
    }
}

