/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import com.amazonaws.util.ValidationUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.qldb.QldbHash;
import software.amazon.qldb.Session;
import software.amazon.qldb.exceptions.Errors;

abstract class BaseTransaction {
    private static final Logger logger = LoggerFactory.getLogger(BaseTransaction.class);
    final Session session;
    final String txnId;
    final AtomicBoolean isClosed = new AtomicBoolean(true);
    final IonSystem ionSystem;
    private QldbHash txnHash;

    BaseTransaction(Session session, String txnId, IonSystem ionSystem) {
        ValidationUtils.assertNotNull((Object)session, (String)"session");
        ValidationUtils.assertNotNull((Object)txnId, (String)"txnId");
        this.session = session;
        this.txnId = txnId;
        this.txnHash = QldbHash.toQldbHash(this.txnId, ionSystem);
        this.ionSystem = ionSystem;
        this.isClosed.set(false);
    }

    public String getTransactionId() {
        return this.txnId;
    }

    static QldbHash dot(QldbHash seed, String statement, List<IonValue> parameters, IonSystem ionSystem) {
        QldbHash statementHash = QldbHash.toQldbHash(statement, ionSystem);
        for (IonValue param : parameters) {
            statementHash = statementHash.dot(QldbHash.toQldbHash(param, ionSystem));
        }
        return seed.dot(statementHash);
    }

    QldbHash getTransactionHash() {
        return this.txnHash;
    }

    void setTransactionHash(QldbHash hash) {
        this.txnHash = hash;
    }

    void throwIfClosed() {
        if (this.isClosed.get()) {
            logger.error(Errors.TXN_CLOSED.get());
            throw new IllegalStateException(Errors.TXN_CLOSED.get());
        }
    }
}

