/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonValue;
import com.amazon.ion.IonWriter;
import com.amazon.ion.system.IonBinaryWriterBuilder;
import com.amazonaws.AmazonClientException;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.services.qldbsession.AmazonQLDBSession;
import com.amazonaws.services.qldbsession.model.AbortTransactionRequest;
import com.amazonaws.services.qldbsession.model.AbortTransactionResult;
import com.amazonaws.services.qldbsession.model.CommitTransactionRequest;
import com.amazonaws.services.qldbsession.model.EndSessionRequest;
import com.amazonaws.services.qldbsession.model.EndSessionResult;
import com.amazonaws.services.qldbsession.model.ExecuteStatementRequest;
import com.amazonaws.services.qldbsession.model.ExecuteStatementResult;
import com.amazonaws.services.qldbsession.model.FetchPageRequest;
import com.amazonaws.services.qldbsession.model.Page;
import com.amazonaws.services.qldbsession.model.SendCommandRequest;
import com.amazonaws.services.qldbsession.model.SendCommandResult;
import com.amazonaws.services.qldbsession.model.StartSessionRequest;
import com.amazonaws.services.qldbsession.model.StartTransactionRequest;
import com.amazonaws.services.qldbsession.model.ValueHolder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.qldb.exceptions.Errors;
import software.amazon.qldb.exceptions.QldbClientException;

@ThreadSafe
class Session
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    private final String ledgerName;
    private final String sessionToken;
    private final AmazonQLDBSession client;

    private Session(String ledgerName, String sessionToken, AmazonQLDBSession client) {
        this.ledgerName = ledgerName;
        this.client = client;
        this.sessionToken = sessionToken;
    }

    static Session startSession(String ledgerName, AmazonQLDBSession client) {
        StartSessionRequest request = new StartSessionRequest().withLedgerName(ledgerName);
        SendCommandRequest command = new SendCommandRequest().withStartSession(request);
        logger.debug("Sending start session request: {}", (Object)command);
        SendCommandResult result = client.sendCommand(command);
        String sessionToken = result.getStartSession().getSessionToken();
        return new Session(ledgerName, sessionToken, client);
    }

    String getLedgerName() {
        return this.ledgerName;
    }

    String getToken() {
        return this.sessionToken;
    }

    @Override
    public void close() {
        try {
            this.sendEndSession();
        }
        catch (AmazonClientException e) {
            logger.warn("Errors closing session: " + e.getMessage(), (Throwable)e);
        }
    }

    AbortTransactionResult sendAbort() {
        AbortTransactionRequest request = new AbortTransactionRequest();
        SendCommandResult result = this.send(new SendCommandRequest().withAbortTransaction(request));
        return result.getAbortTransaction();
    }

    ByteBuffer sendCommit(String txnId, ByteBuffer transactionDigest) {
        CommitTransactionRequest request = new CommitTransactionRequest().withTransactionId(txnId).withCommitDigest(transactionDigest);
        SendCommandResult result = this.send(new SendCommandRequest().withCommitTransaction(request));
        return result.getCommitTransaction().getCommitDigest();
    }

    EndSessionResult sendEndSession() {
        EndSessionRequest request = new EndSessionRequest();
        SendCommandResult result = this.send(new SendCommandRequest().withEndSession(request));
        return result.getEndSession();
    }

    ExecuteStatementResult sendExecute(String statement, List<IonValue> parameters, String txnId) {
        ArrayList<ValueHolder> byteParameters = new ArrayList<ValueHolder>(parameters.size());
        if (!parameters.isEmpty()) {
            try {
                IonBinaryWriterBuilder builder = IonBinaryWriterBuilder.standard();
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                IonWriter writer = builder.build((OutputStream)stream);
                for (IonValue parameter : parameters) {
                    parameter.writeTo(writer);
                    writer.finish();
                    byteParameters.add(new ValueHolder().withIonBinary(ByteBuffer.wrap(stream.toByteArray())));
                    stream.reset();
                }
            }
            catch (IOException e) {
                throw QldbClientException.create(String.format(Errors.SERIALIZING_PARAMS.get(), e.getMessage()), e, logger);
            }
        }
        ExecuteStatementRequest request = new ExecuteStatementRequest().withStatement(statement).withParameters(byteParameters).withTransactionId(txnId);
        SendCommandResult result = this.send(new SendCommandRequest().withExecuteStatement(request));
        return result.getExecuteStatement();
    }

    Page sendFetchPage(String txnId, String nextPageToken) {
        FetchPageRequest request = new FetchPageRequest().withTransactionId(txnId).withNextPageToken(nextPageToken);
        SendCommandResult result = this.send(new SendCommandRequest().withFetchPage(request));
        return result.getFetchPage().getPage();
    }

    String sendStartTransaction() {
        StartTransactionRequest request = new StartTransactionRequest();
        SendCommandRequest command = new SendCommandRequest().withStartTransaction(request);
        SendCommandResult result = this.send(command);
        return result.getStartTransaction().getTransactionId();
    }

    private SendCommandResult send(SendCommandRequest request) {
        SendCommandRequest command = request.withSessionToken(this.sessionToken);
        logger.debug("Sending request: {}", (Object)command);
        return this.client.sendCommand(command);
    }
}

