/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import com.amazon.ionhash.IonHashReader;
import com.amazon.ionhash.IonHashReaderBuilder;
import com.amazon.ionhash.IonHasherProvider;
import com.amazon.ionhash.MessageDigestIonHasherProvider;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QldbHash {
    private static final Logger logger = LoggerFactory.getLogger(QldbHash.class);
    private static final int HASH_SIZE = 32;
    private byte[] qldbHash;
    private final IonSystem ionSystem;
    private static final MessageDigestIonHasherProvider hasherProvider = new MessageDigestIonHasherProvider("SHA-256");
    private static Comparator<byte[]> hashComparator = (h1, h2) -> {
        if (((byte[])h1).length != 32 || ((byte[])h2).length != 32) {
            throw new IllegalArgumentException("Invalid hash");
        }
        for (int i = ((byte[])h1).length - 1; i >= 0; --i) {
            int byteEqual = Byte.compare(h1[i], h2[i]);
            if (byteEqual == 0) continue;
            return byteEqual;
        }
        return 0;
    };

    public static QldbHash toQldbHash(String value, IonSystem ionSystem) {
        if (null == value) {
            return QldbHash.toQldbHash((IonValue)ionSystem.newString(""), ionSystem);
        }
        return QldbHash.toQldbHash((IonValue)ionSystem.newString(value), ionSystem);
    }

    public static QldbHash toQldbHash(IonValue value, IonSystem ionSystem) {
        IonReader reader = ionSystem.newReader(value);
        IonHashReader hashReader = IonHashReaderBuilder.standard().withHasherProvider((IonHasherProvider)hasherProvider).withReader(reader).build();
        while (hashReader.next() != null) {
        }
        return new QldbHash(hashReader.digest(), ionSystem);
    }

    public QldbHash(byte[] qldbHash, IonSystem ionSystem) {
        if (qldbHash == null || qldbHash.length != 32 && qldbHash.length != 0) {
            throw new IllegalArgumentException(String.format("Hashes must either be empty or %d bytes long", 32));
        }
        this.ionSystem = ionSystem;
        this.qldbHash = qldbHash;
    }

    public int getHashSize() {
        return this.qldbHash.length;
    }

    public boolean isEmpty() {
        return this.qldbHash.length == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (byte it : this.qldbHash) {
            stringBuffer.append(String.format("%02x", it));
        }
        return stringBuffer.toString();
    }

    public byte[] getQldbHash() {
        return this.qldbHash;
    }

    public boolean equals(Object other) {
        if (null == other || !(other instanceof QldbHash)) {
            return false;
        }
        return hashComparator.compare(this.getQldbHash(), ((QldbHash)other).getQldbHash()) == 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getQldbHash());
    }

    public QldbHash dot(QldbHash that) {
        byte[] concatenated = this.joinHashesPairwise(this.getQldbHash(), that.getQldbHash());
        MessageDigest messageDigest = QldbHash.newMessageDigest();
        messageDigest.update(concatenated);
        return new QldbHash(messageDigest.digest(), this.ionSystem);
    }

    private byte[] joinHashesPairwise(byte[] h1, byte[] h2) {
        if (h1.length == 0) {
            return h2;
        }
        if (h2.length == 0) {
            return h1;
        }
        byte[] concatenated = new byte[h1.length + h2.length];
        if (hashComparator.compare(h1, h2) < 0) {
            System.arraycopy(h1, 0, concatenated, 0, h1.length);
            System.arraycopy(h2, 0, concatenated, h1.length, h2.length);
        } else {
            System.arraycopy(h2, 0, concatenated, 0, h2.length);
            System.arraycopy(h1, 0, concatenated, h2.length, h1.length);
        }
        return concatenated;
    }

    private static MessageDigest newMessageDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Failed to create SHA-256 MessageDigest", (Throwable)e);
            throw new IllegalStateException("SHA-256 message digest is unavailable", e);
        }
    }
}

