/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import com.amazonaws.AmazonClientException;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.services.qldbsession.model.AmazonQLDBSessionException;
import com.amazonaws.services.qldbsession.model.InvalidSessionException;
import com.amazonaws.services.qldbsession.model.OccConflictException;
import com.amazonaws.util.ValidationUtils;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.http.NoHttpResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.qldb.BaseQldbSession;
import software.amazon.qldb.BufferedResult;
import software.amazon.qldb.Executor;
import software.amazon.qldb.ExecutorNoReturn;
import software.amazon.qldb.QldbSession;
import software.amazon.qldb.Result;
import software.amazon.qldb.RetryIndicator;
import software.amazon.qldb.Session;
import software.amazon.qldb.StreamResult;
import software.amazon.qldb.TableNameIterable;
import software.amazon.qldb.Transaction;
import software.amazon.qldb.TransactionExecutor;
import software.amazon.qldb.TransactionImpl;
import software.amazon.qldb.exceptions.AbortException;

@NotThreadSafe
class QldbSessionImpl
extends BaseQldbSession
implements QldbSession {
    private static final Logger logger = LoggerFactory.getLogger(QldbSessionImpl.class);
    private final int readAhead;
    private final ExecutorService executorService;

    QldbSessionImpl(Session session, int retryLimit, int readAhead, IonSystem ionSystem, ExecutorService executorService) {
        super(session, retryLimit, ionSystem);
        this.readAhead = readAhead;
        this.executorService = executorService;
    }

    @Override
    public void close() {
        if (!this.isClosed.getAndSet(true)) {
            this.session.close();
        }
    }

    @Override
    public Result execute(String statement) {
        return this.execute(statement, Collections.emptyList());
    }

    @Override
    public Result execute(String statement, List<IonValue> parameters) {
        ValidationUtils.assertStringNotEmpty((String)statement, (String)"statement");
        ValidationUtils.assertNotNull(parameters, (String)"parameters");
        return this.execute((TransactionExecutor txn) -> txn.execute(statement, parameters), null);
    }

    @Override
    public void execute(ExecutorNoReturn executor) {
        this.execute(executor, null);
    }

    @Override
    public void execute(ExecutorNoReturn executor, RetryIndicator retryIndicator) {
        ValidationUtils.assertNotNull((Object)executor, (String)"executor");
        this.execute((TransactionExecutor txn) -> {
            executor.execute(txn);
            return Boolean.TRUE;
        }, retryIndicator);
    }

    @Override
    public <T> T execute(Executor<T> executor) {
        return this.execute(executor, null);
    }

    @Override
    public <T> T execute(Executor<T> executor, RetryIndicator retryIndicator) {
        this.throwIfClosed();
        ValidationUtils.assertNotNull(executor, (String)"executor");
        int executionAttempt = 0;
        while (true) {
            block11: {
                Transaction transaction = null;
                try {
                    transaction = this.startTransaction();
                    Object returnedValue = executor.execute(new TransactionExecutor(transaction));
                    if (returnedValue instanceof StreamResult) {
                        returnedValue = new BufferedResult((Result)returnedValue);
                    }
                    transaction.commit();
                    return returnedValue;
                }
                catch (InvalidSessionException ise) {
                    this.isClosed.set(true);
                    throw ise;
                }
                catch (AbortException e) {
                    this.noThrowAbort(transaction);
                    throw e;
                }
                catch (OccConflictException oce) {
                    logger.info("OCC conflict occurred: " + oce.getMessage());
                    if (executionAttempt >= this.retryLimit) {
                        throw oce;
                    }
                }
                catch (AmazonQLDBSessionException se) {
                    this.noThrowAbort(transaction);
                    if (executionAttempt >= this.retryLimit || se.getStatusCode() != 500 && se.getStatusCode() != 503) {
                        throw se;
                    }
                }
                catch (AmazonClientException ace) {
                    this.noThrowAbort(transaction);
                    if (executionAttempt < this.retryLimit && (ace.getCause() instanceof NoHttpResponseException || ace.getCause() instanceof SocketTimeoutException)) break block11;
                    throw ace;
                }
            }
            ++executionAttempt;
            if (null != retryIndicator) {
                retryIndicator.onRetry(executionAttempt);
            }
            QldbSessionImpl.retrySleep(executionAttempt);
        }
    }

    @Override
    public Iterable<String> getTableNames() {
        Result result = this.execute("SELECT VALUE name FROM information_schema.user_tables WHERE status = 'ACTIVE'");
        return new TableNameIterable(result);
    }

    @Override
    public Transaction startTransaction() {
        this.throwIfClosed();
        try {
            return new TransactionImpl(this, this.session.sendStartTransaction(), this.readAhead, this.ionSystem, this.executorService);
        }
        catch (InvalidSessionException ise) {
            this.isClosed.set(true);
            throw ise;
        }
    }

    private void noThrowAbort(Transaction transaction) {
        if (null == transaction) {
            return;
        }
        try {
            transaction.abort();
        }
        catch (InvalidSessionException ise) {
            this.isClosed.set(true);
            throw ise;
        }
        catch (AmazonClientException ace) {
            logger.warn("Ignored error aborting transaction during execution.", (Throwable)ace);
        }
    }
}

