/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.payloadoffloading;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.util.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class S3Dao {
    private static final Log LOG = LogFactory.getLog(S3Dao.class);
    private final AmazonS3 s3Client;

    public S3Dao(AmazonS3 s3Client) {
        this.s3Client = s3Client;
    }

    public String getTextFromS3(String s3BucketName, String s3Key) {
        GetObjectRequest getObjectRequest = new GetObjectRequest(s3BucketName, s3Key);
        String embeddedText = null;
        S3Object obj = null;
        try {
            obj = this.s3Client.getObject(getObjectRequest);
        }
        catch (AmazonServiceException e) {
            String errorMessage = "Failed to get the S3 object which contains the payload.";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new AmazonServiceException(errorMessage, (Exception)((Object)e));
        }
        catch (AmazonClientException e) {
            String errorMessage = "Failed to get the S3 object which contains the payload.";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new AmazonClientException(errorMessage, (Throwable)e);
        }
        S3ObjectInputStream is = obj.getObjectContent();
        try {
            embeddedText = IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            String errorMessage = "Failure when handling the message which was read from S3 object.";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new AmazonClientException(errorMessage, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)is, (Log)LOG);
        }
        return embeddedText;
    }

    public void storeTextInS3(String s3BucketName, String s3Key, SSEAwsKeyManagementParams sseAwsKeyManagementParams, String payloadContentStr, Long payloadContentSize) {
        ByteArrayInputStream payloadContentStream = new ByteArrayInputStream(payloadContentStr.getBytes(StandardCharsets.UTF_8));
        ObjectMetadata payloadContentStreamMetadata = new ObjectMetadata();
        payloadContentStreamMetadata.setContentLength(payloadContentSize.longValue());
        PutObjectRequest putObjectRequest = new PutObjectRequest(s3BucketName, s3Key, (InputStream)payloadContentStream, payloadContentStreamMetadata);
        if (sseAwsKeyManagementParams != null) {
            LOG.debug((Object)"Using SSE-KMS in put object request.");
            putObjectRequest.setSSEAwsKeyManagementParams(sseAwsKeyManagementParams);
        }
        try {
            this.s3Client.putObject(putObjectRequest);
        }
        catch (AmazonServiceException e) {
            String errorMessage = "Failed to store the message content in an S3 object.";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new AmazonServiceException(errorMessage, (Exception)((Object)e));
        }
        catch (AmazonClientException e) {
            String errorMessage = "Failed to store the message content in an S3 object.";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new AmazonClientException(errorMessage, (Throwable)e);
        }
    }

    public void storeTextInS3(String s3BucketName, String s3Key, String payloadContentStr, Long payloadContentSize) {
        this.storeTextInS3(s3BucketName, s3Key, null, payloadContentStr, payloadContentSize);
    }

    public void deletePayloadFromS3(String s3BucketName, String s3Key) {
        try {
            this.s3Client.deleteObject(s3BucketName, s3Key);
        }
        catch (AmazonServiceException e) {
            String errorMessage = "Failed to delete the S3 object which contains the payload";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new AmazonServiceException(errorMessage, (Exception)((Object)e));
        }
        catch (AmazonClientException e) {
            String errorMessage = "Failed to delete the S3 object which contains the payload";
            LOG.error((Object)errorMessage, (Throwable)e);
            throw new AmazonClientException(errorMessage, (Throwable)e);
        }
        LOG.info((Object)("S3 object deleted, Bucket name: " + s3BucketName + ", Object key: " + s3Key + "."));
    }
}

