/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.api;

import com.amazon.pay.api.PayConfiguration;
import com.amazon.pay.api.Util;
import com.amazon.pay.api.exceptions.AmazonPayClientException;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class SignatureHelper {
    private final PayConfiguration payConfiguration;
    private final String LINE_SEPARATOR = "\n";
    public static final int SALT_LENGTH = 20;
    public static final int TRAILER_FIELD = 1;

    public SignatureHelper(PayConfiguration payConfiguration) {
        this.payConfiguration = payConfiguration;
    }

    public String createCanonicalRequest(URI uri, String httpMethodName, Map<String, List<String>> parameters, String requestPayload, Map<String, List<String>> preSignedHeaders) throws AmazonPayClientException {
        String path = uri.getPath();
        StringBuilder canonicalRequestBuilder = new StringBuilder(httpMethodName);
        try {
            canonicalRequestBuilder.append("\n").append(this.getCanonicalizedURI(path)).append("\n").append(this.getCanonicalizedQueryString(parameters)).append("\n").append(this.getCanonicalizedHeaderString(preSignedHeaders)).append("\n").append(this.getSignedHeadersString(preSignedHeaders)).append("\n").append(this.hashThenHexEncode(requestPayload));
        }
        catch (NoSuchAlgorithmException e) {
            throw new AmazonPayClientException(e.getMessage(), e);
        }
        return canonicalRequestBuilder.toString();
    }

    public String createStringToSign(String canonicalRequest) throws NoSuchAlgorithmException {
        String hashedCanonicalRequest = this.hashThenHexEncode(canonicalRequest);
        StringBuilder stringToSignBuilder = new StringBuilder("AMZN-PAY-RSASSA-PSS");
        stringToSignBuilder.append("\n").append(hashedCanonicalRequest);
        return stringToSignBuilder.toString();
    }

    public String generateSignature(String stringToSign, PrivateKey privateKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance("SHA256WithRSA/PSS", "BC");
        MGF1ParameterSpec mgf1ParameterSpec = new MGF1ParameterSpec("SHA-256");
        PSSParameterSpec pssParameterSpec = new PSSParameterSpec("SHA-256", "MGF1", mgf1ParameterSpec, 20, 1);
        signature.setParameter(pssParameterSpec);
        signature.initSign(privateKey);
        signature.update(stringToSign.getBytes());
        return new String(Base64.encode((byte[])signature.sign()));
    }

    public Map<String, List<String>> createPreSignedHeaders(URI uri, Map<String, String> header) throws AmazonPayClientException {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        ArrayList<String> acceptHeaderValue = new ArrayList<String>();
        acceptHeaderValue.add("application/json");
        headers.put("accept", acceptHeaderValue);
        ArrayList<String> contentHeaderValue = new ArrayList<String>();
        contentHeaderValue.add("application/json");
        headers.put("content-type", contentHeaderValue);
        ArrayList<String> regionHeaderValue = new ArrayList<String>();
        regionHeaderValue.add(this.payConfiguration.getRegion().toString());
        headers.put("x-amz-pay-region", regionHeaderValue);
        ArrayList<String> dateHeaderValue = new ArrayList<String>();
        dateHeaderValue.add(Util.getFormattedTimestamp());
        headers.put("x-amz-pay-date", dateHeaderValue);
        ArrayList<String> hostHeaderValue = new ArrayList<String>();
        hostHeaderValue.add(uri.getHost());
        headers.put("x-amz-pay-host", hostHeaderValue);
        if (header == null || header.isEmpty()) {
            return headers;
        }
        HashMap<String, String> lowerCaseUserHeader = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : header.entrySet()) {
            lowerCaseUserHeader.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        Set headersKeySet = headers.keySet();
        for (Map.Entry entry : lowerCaseUserHeader.entrySet()) {
            if (headersKeySet.contains(entry.getKey())) {
                ArrayList alreadyPresentHeaderValue = new ArrayList();
                alreadyPresentHeaderValue.add(entry.getValue());
                headers.put((String)entry.getKey(), alreadyPresentHeaderValue);
                continue;
            }
            ArrayList newHeaderValue = new ArrayList();
            newHeaderValue.add(entry.getValue());
            headers.put((String)entry.getKey(), newHeaderValue);
        }
        return headers;
    }

    public String getSignedHeadersString(Map<String, List<String>> preSignedHeaders) {
        ArrayList<String> sortedHeaders = new ArrayList<String>(preSignedHeaders.keySet());
        Collections.sort(sortedHeaders, String.CASE_INSENSITIVE_ORDER);
        StringBuilder buffer = new StringBuilder();
        for (String header : sortedHeaders) {
            if (buffer.length() > 0) {
                buffer.append(";");
            }
            buffer.append(Util.lowerCase(header));
        }
        return buffer.toString();
    }

    public String getCanonicalizedHeaderString(Map<String, List<String>> preSignedHeaders) {
        ArrayList<String> sortedHeaders = new ArrayList<String>(preSignedHeaders.keySet());
        Collections.sort(sortedHeaders, String.CASE_INSENSITIVE_ORDER);
        Map<String, List<String>> requestHeaders = preSignedHeaders;
        StringBuilder buffer = new StringBuilder();
        for (String header : sortedHeaders) {
            String key = Util.lowerCase(header);
            List<String> values = requestHeaders.get(header);
            StringBuilder headerValue = new StringBuilder();
            for (String value : values) {
                if (headerValue == null) continue;
                if (headerValue.length() > 0) {
                    headerValue.append(",");
                }
                headerValue.append(value.trim().replaceAll("\\s", " "));
            }
            buffer.append(key.trim().replaceAll("\\s", " "));
            buffer.append(":");
            if (headerValue != null) {
                buffer.append((CharSequence)headerValue);
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public String getCanonicalizedQueryString(Map<String, List<String>> parameters) throws AmazonPayClientException {
        TreeMap sorted = new TreeMap();
        if (parameters != null) {
            for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
                String encodedParamName = Util.urlEncode(entry.getKey(), false);
                List<String> paramValues = entry.getValue();
                ArrayList<String> encodedValues = new ArrayList<String>(paramValues.size());
                for (String value : paramValues) {
                    encodedValues.add(Util.urlEncode(value, false));
                }
                Collections.sort(encodedValues);
                sorted.put(encodedParamName, encodedValues);
            }
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : sorted.entrySet()) {
            for (String value : (List)entry.getValue()) {
                if (result.length() > 0) {
                    result.append("&");
                }
                result.append((String)entry.getKey()).append("=").append(value);
            }
        }
        return result.toString();
    }

    private String getCanonicalizedURI(String path) throws AmazonPayClientException {
        if (path == null || path.isEmpty()) {
            return "/";
        }
        String value = Util.urlEncode(path, true);
        if (value.startsWith("/")) {
            return value;
        }
        return "/".concat(value);
    }

    private String hashThenHexEncode(String requestPayload) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(requestPayload.getBytes());
        byte[] digest = md.digest();
        String contentSha256 = new String(Hex.encode((byte[])digest));
        return contentSha256;
    }
}

