/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.driver.AcquireConnectionConfig;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.ClientClusterCollection;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.ClusterFactory;
import org.apache.tinkerpop.gremlin.driver.DatabaseEndpoint;
import org.apache.tinkerpop.gremlin.driver.Endpoint;
import org.apache.tinkerpop.gremlin.driver.EndpointClient;
import org.apache.tinkerpop.gremlin.driver.EndpointClientCollection;
import org.apache.tinkerpop.gremlin.driver.EndpointCollection;
import org.apache.tinkerpop.gremlin.driver.EndpointStrategies;
import org.apache.tinkerpop.gremlin.driver.EndpointsUnavailableException;
import org.apache.tinkerpop.gremlin.driver.GremlinClient;
import org.apache.tinkerpop.gremlin.driver.MetricsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.utils.GitProperties;
import software.amazon.utils.SoftwareVersion;

public class GremlinCluster
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(GremlinCluster.class);
    private final Collection<Endpoint> defaultEndpoints;
    private final ClusterFactory clusterFactory;
    private final Collection<ClientClusterCollection> clientClusterCollections = new CopyOnWriteArrayList<ClientClusterCollection>();
    private final AtomicReference<CompletableFuture<Void>> closing = new AtomicReference<Object>(null);
    private final EndpointStrategies endpointStrategies;
    private final AcquireConnectionConfig acquireConnectionConfig;
    private final Map<Class<? extends Exception>, Set<String>> ignoreExceptionsDuringEndpointCreation;
    private final MetricsConfig metricsConfig;

    public GremlinCluster(Collection<Endpoint> defaultEndpoints, ClusterFactory clusterFactory, EndpointStrategies endpointStrategies, AcquireConnectionConfig acquireConnectionConfig, MetricsConfig metricsConfig, Map<Class<? extends Exception>, Set<String>> ignoreExceptionsDuringEndpointCreation) {
        logger.info("Version: {} {}", (Object)SoftwareVersion.FromResource, (Object)GitProperties.FromResource);
        logger.info("Created GremlinCluster [defaultEndpoints: {}, enableMetrics: {}]", defaultEndpoints.stream().map(Endpoint::getAddress).collect(Collectors.toList()), (Object)metricsConfig.enableMetrics());
        this.defaultEndpoints = defaultEndpoints;
        this.clusterFactory = clusterFactory;
        this.endpointStrategies = endpointStrategies;
        this.acquireConnectionConfig = acquireConnectionConfig;
        this.metricsConfig = metricsConfig;
        this.ignoreExceptionsDuringEndpointCreation = ignoreExceptionsDuringEndpointCreation;
    }

    public GremlinClient connect(List<String> addresses, Client.Settings settings) {
        return this.connectToEndpoints(addresses.stream().map(a -> new DatabaseEndpoint().withAddress((String)a)).collect(Collectors.toList()), settings);
    }

    public GremlinClient connectToEndpoints(Collection<Endpoint> endpoints, Client.Settings settings) {
        logger.info("Connecting with: {}", endpoints.stream().map(Endpoint::getAddress).collect(Collectors.toList()));
        if (endpoints.isEmpty()) {
            throw new IllegalStateException("You must supply at least one endpoint");
        }
        Cluster parentCluster = this.clusterFactory.createCluster(null);
        ClientClusterCollection clientClusterCollection = new ClientClusterCollection(this.clusterFactory, parentCluster);
        Map<Endpoint, Cluster> clustersForEndpoints = clientClusterCollection.createClustersForEndpoints(new EndpointCollection(endpoints));
        List<EndpointClient> newEndpointClients = EndpointClient.create(clustersForEndpoints, this.ignoreExceptionsDuringEndpointCreation);
        HashSet<Endpoint> rejectedEndpoints = new HashSet<Endpoint>(clustersForEndpoints.keySet());
        newEndpointClients.forEach(i -> rejectedEndpoints.remove(i.endpoint()));
        EndpointCollection rejectedEndpointsCollection = new EndpointCollection(rejectedEndpoints);
        clientClusterCollection.removeClusterWithMatchingEndpoint(rejectedEndpointsCollection);
        if (newEndpointClients.isEmpty()) {
            throw new EndpointsUnavailableException(List.of("None of the endpoints supplied are available !"));
        }
        EndpointClientCollection endpointClientCollection = new EndpointClientCollection(EndpointClientCollection.builder().withEndpointClients(newEndpointClients).withRejectedEndpoints(rejectedEndpointsCollection).setCollectMetrics(this.metricsConfig.enableMetrics()));
        this.clientClusterCollections.add(clientClusterCollection);
        return new GremlinClient(clientClusterCollection.getParentCluster(), settings, endpointClientCollection, clientClusterCollection, this.endpointStrategies, this.acquireConnectionConfig, this.metricsConfig, this.ignoreExceptionsDuringEndpointCreation);
    }

    public GremlinClient connect(List<String> addresses) {
        return this.connect(addresses, Client.Settings.build().create());
    }

    public GremlinClient connectToEndpoints(List<Endpoint> endpoints) {
        return this.connectToEndpoints(endpoints, Client.Settings.build().create());
    }

    public GremlinClient connect() {
        return this.connectToEndpoints(this.defaultEndpoints, Client.Settings.build().create());
    }

    public GremlinClient connect(Client.Settings settings) {
        return this.connectToEndpoints(this.defaultEndpoints, settings);
    }

    public CompletableFuture<Void> closeAsync() {
        if (this.closing.get() != null) {
            return this.closing.get();
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (ClientClusterCollection clientClusterCollection : this.clientClusterCollections) {
            futures.add(clientClusterCollection.closeAsync());
        }
        this.closing.set(CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])));
        return this.closing.get();
    }

    @Override
    public void close() throws Exception {
        this.closeAsync().join();
    }
}

