/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.neptune.cluster;

import com.evanlennick.retry4j.CallExecutor;
import com.evanlennick.retry4j.CallExecutorBuilder;
import com.evanlennick.retry4j.Status;
import com.evanlennick.retry4j.config.RetryConfig;
import com.evanlennick.retry4j.config.RetryConfigBuilder;
import com.evanlennick.retry4j.exception.UnexpectedException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.driver.EndpointCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.LambdaClientBuilder;
import software.amazon.awssdk.services.lambda.model.InvokeRequest;
import software.amazon.awssdk.services.lambda.model.InvokeResponse;
import software.amazon.awssdk.services.lambda.model.TooManyRequestsException;
import software.amazon.neptune.cluster.ClusterEndpointsFetchStrategy;
import software.amazon.neptune.cluster.ClusterMetadataSupplier;
import software.amazon.neptune.cluster.CommonClusterEndpointsFetchStrategy;
import software.amazon.neptune.cluster.EndpointsSelector;
import software.amazon.neptune.cluster.NeptuneClusterMetadata;
import software.amazon.utils.RegionUtils;

class GetEndpointsFromLambdaProxy
implements ClusterEndpointsFetchStrategy,
ClusterMetadataSupplier {
    private static final Logger logger = LoggerFactory.getLogger(GetEndpointsFromLambdaProxy.class);
    private static final long FIFTEEN_SECONDS = 15000L;
    private final ClusterEndpointsFetchStrategy innerStrategy;
    private final String lambdaName;
    private final LambdaClient lambdaClient;
    private final RetryConfig retryConfig;
    private final AtomicReference<NeptuneClusterMetadata> cachedClusterMetadata = new AtomicReference();
    private final AtomicLong lastRefreshTime = new AtomicLong(System.currentTimeMillis());

    GetEndpointsFromLambdaProxy(String lambdaName) {
        this(lambdaName, RegionUtils.getCurrentRegionName());
    }

    GetEndpointsFromLambdaProxy(String lambdaName, String region) {
        this(lambdaName, region, "default");
    }

    GetEndpointsFromLambdaProxy(String lambdaName, String region, String iamProfile) {
        this(lambdaName, region, iamProfile, null, null, null);
    }

    GetEndpointsFromLambdaProxy(String lambdaName, String region, String iamProfile, ClientOverrideConfiguration clientConfiguration) {
        this(lambdaName, region, iamProfile, null, clientConfiguration, null);
    }

    GetEndpointsFromLambdaProxy(String lambdaName, String region, String iamProfile, ClientOverrideConfiguration clientConfiguration, SdkHttpClient.Builder<?> httpClientBuilder) {
        this(lambdaName, region, iamProfile, null, clientConfiguration, httpClientBuilder);
    }

    GetEndpointsFromLambdaProxy(String lambdaName, String region, AwsCredentialsProvider credentials) {
        this(lambdaName, region, "default", credentials, null, null);
    }

    GetEndpointsFromLambdaProxy(String lambdaName, String region, AwsCredentialsProvider credentials, ClientOverrideConfiguration clientConfiguration) {
        this(lambdaName, region, "default", credentials, clientConfiguration, null);
    }

    GetEndpointsFromLambdaProxy(String lambdaName, String region, AwsCredentialsProvider credentials, ClientOverrideConfiguration clientConfiguration, SdkHttpClient.Builder<?> httpClientBuilder) {
        this(lambdaName, region, "default", credentials, clientConfiguration, httpClientBuilder);
    }

    private GetEndpointsFromLambdaProxy(String lambdaName, String region, String iamProfile, AwsCredentialsProvider credentials, ClientOverrideConfiguration clientOverrideConfiguration, SdkHttpClient.Builder<?> httpClientBuilder) {
        this.innerStrategy = new CommonClusterEndpointsFetchStrategy(this);
        this.lambdaName = lambdaName;
        this.lambdaClient = this.createLambdaClient(region, iamProfile, credentials, clientOverrideConfiguration, httpClientBuilder);
        this.retryConfig = new RetryConfigBuilder().retryOnSpecificExceptions(new Class[]{TooManyRequestsException.class, TimeoutException.class}).withMaxNumberOfTries(5).withDelayBetweenTries(100L, ChronoUnit.MILLIS).withExponentialBackoff().build();
    }

    @Override
    public ClusterMetadataSupplier clusterMetadataSupplier() {
        return this;
    }

    @Override
    public NeptuneClusterMetadata refreshClusterMetadata() {
        Status status;
        Callable<NeptuneClusterMetadata> query = () -> {
            InvokeRequest invokeRequest = (InvokeRequest)InvokeRequest.builder().functionName(this.lambdaName).payload(SdkBytes.fromUtf8String((String)"\"\"")).build();
            InvokeResponse result = this.lambdaClient.invoke(invokeRequest);
            if (StringUtils.isNotEmpty((CharSequence)result.functionError())) {
                String payload = result.payload().asUtf8String();
                if (payload.contains("Task timed out after")) {
                    throw new TimeoutException(String.format("Lambda proxy invocation timed out. Last error message: %s", payload));
                }
                throw new RuntimeException(String.format("Unexpected error while invoking Lambda proxy: %s", payload));
            }
            return NeptuneClusterMetadata.fromByteArray(result.payload().asByteArray());
        };
        CallExecutor executor = new CallExecutorBuilder().config(this.retryConfig).build();
        try {
            status = executor.execute(query);
        }
        catch (UnexpectedException e) {
            if (e.getCause() instanceof MismatchedInputException) {
                throw new IllegalStateException(String.format("The AWS Lambda proxy (%s) isn't returning a NeptuneClusterMetadata JSON document. Check that the function supports returning a NeptuneClusterMetadata JSON document.", this.lambdaName), e.getCause());
            }
            throw new IllegalStateException(String.format("There was an unexpected error while attempting to get a NeptuneClusterMetadata JSON document from the AWS Lambda proxy (%s). Check that the function supports returning a NeptuneClusterMetadata JSON document.", this.lambdaName), e.getCause());
        }
        NeptuneClusterMetadata clusterMetadata = (NeptuneClusterMetadata)status.getResult();
        this.cachedClusterMetadata.set(clusterMetadata);
        logger.debug("clusterMetadata: {}", (Object)clusterMetadata);
        return clusterMetadata;
    }

    @Override
    public NeptuneClusterMetadata getClusterMetadata() {
        NeptuneClusterMetadata clusterMetadata = this.cachedClusterMetadata.get();
        if (clusterMetadata == null) {
            return this.refreshClusterMetadata();
        }
        if (this.shouldRefresh()) {
            return this.refreshClusterMetadata();
        }
        return clusterMetadata;
    }

    @Override
    public Map<? extends EndpointsSelector, EndpointCollection> getEndpoints(Collection<? extends EndpointsSelector> selectors, boolean refresh) {
        return this.innerStrategy.getEndpoints(selectors, refresh);
    }

    private boolean shouldRefresh() {
        long now = System.currentTimeMillis();
        long refreshTime = this.lastRefreshTime.updateAndGet(currentValue -> now - currentValue > 15000L ? now : currentValue);
        return refreshTime == now;
    }

    private LambdaClient createLambdaClient(String region, String iamProfile, AwsCredentialsProvider credentials, ClientOverrideConfiguration clientConfiguration, SdkHttpClient.Builder<?> httpClientBuilder) {
        LambdaClientBuilder builder = LambdaClient.builder();
        if (clientConfiguration != null) {
            builder = (LambdaClientBuilder)builder.overrideConfiguration(clientConfiguration);
        }
        builder = credentials != null ? (LambdaClientBuilder)builder.credentialsProvider(credentials) : (!iamProfile.equals("default") ? (LambdaClientBuilder)builder.credentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.create((String)iamProfile)) : (LambdaClientBuilder)builder.credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create()));
        if (StringUtils.isNotEmpty((CharSequence)region)) {
            builder = (LambdaClientBuilder)builder.region(Region.of((String)region));
        }
        if (httpClientBuilder != null) {
            builder = (LambdaClientBuilder)builder.httpClientBuilder(httpClientBuilder);
        }
        return (LambdaClient)builder.build();
    }
}

