/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.Endpoint;

public class DatabaseEndpoint
implements Endpoint {
    private String address;
    private final Map<String, String> annotations = new HashMap<String, String>();

    public void setAddress(String address) {
        this.address = address;
    }

    @Deprecated
    public void setEndpoint(String endpoint) {
        this.address = endpoint;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations.clear();
        this.annotations.putAll(annotations);
    }

    public DatabaseEndpoint withAddress(String endpoint) {
        this.setAddress(endpoint);
        return this;
    }

    public DatabaseEndpoint withAnnotations(Map<String, String> annotations) {
        this.setAnnotations(annotations);
        return this;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    @JsonIgnore
    public boolean isAvailable() {
        return true;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public void setAnnotation(String key, String value) {
        this.annotations.put(key, value);
    }

    public String toString() {
        return "DatabaseEndpoint{address='" + this.address + '\'' + ", annotations=" + this.annotations + '}';
    }
}

