/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.neptune.cluster;

import com.amazonaws.auth.AWSCredentialsProvider;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Endpoint;
import org.apache.tinkerpop.gremlin.driver.EndpointCollection;
import org.apache.tinkerpop.gremlin.driver.HandshakeInterceptor;
import org.apache.tinkerpop.gremlin.driver.TopologyAwareBuilderConfigurator;
import software.amazon.neptune.cluster.IamAuthConfig;
import software.amazon.neptune.cluster.LBAwareHandshakeInterceptor;

class HandshakeInterceptorConfigurator
implements TopologyAwareBuilderConfigurator {
    private final boolean isDirectConnection;
    private final HandshakeInterceptor interceptor;
    private final boolean enableIamAuth;
    private final int port;
    private final int proxyPort;
    private final String proxyAddress;
    private final String serviceRegion;
    private final String iamProfile;
    private final AWSCredentialsProvider credentials;
    private final boolean removeHostHeader;

    HandshakeInterceptorConfigurator(boolean isDirectConnection, HandshakeInterceptor interceptor, boolean enableIamAuth, int port, int proxyPort, String proxyAddress, String serviceRegion, String iamProfile, AWSCredentialsProvider credentials, boolean removeHostHeader) {
        this.isDirectConnection = isDirectConnection;
        this.interceptor = interceptor;
        this.enableIamAuth = enableIamAuth;
        this.port = port;
        this.proxyPort = proxyPort;
        this.proxyAddress = proxyAddress;
        this.serviceRegion = serviceRegion;
        this.iamProfile = iamProfile;
        this.credentials = credentials;
        this.removeHostHeader = removeHostHeader;
    }

    @Override
    public void apply(Cluster.Builder builder, EndpointCollection endpoints) {
        if (endpoints == null || endpoints.isEmpty()) {
            return;
        }
        if (this.isDirectConnection) {
            builder.port(this.port);
            for (Endpoint endpoint : endpoints) {
                builder.addContactPoint(endpoint.getAddress());
            }
        } else {
            builder.port(this.proxyPort);
            if (this.proxyAddress != null) {
                builder.addContactPoint(this.proxyAddress);
            }
        }
        if (this.interceptor != null) {
            builder.handshakeInterceptor(this.interceptor);
        } else {
            IamAuthConfig.IamAuthConfigBuilder iamAuthConfigBuilder = IamAuthConfig.builder().addNeptuneEndpoints(endpoints.stream().map(Endpoint::getAddress).collect(Collectors.toList())).setNeptunePort(this.port).setServiceRegion(this.serviceRegion).setIamProfile(this.iamProfile).setCredentials(this.credentials);
            if (this.enableIamAuth) {
                iamAuthConfigBuilder.enableIamAuth();
            }
            if (!this.isDirectConnection) {
                iamAuthConfigBuilder.connectViaLoadBalancer();
            }
            if (this.removeHostHeader) {
                iamAuthConfigBuilder.removeHostHeaderAfterSigning();
            }
            IamAuthConfig iamAuthConfig = iamAuthConfigBuilder.build();
            builder.handshakeInterceptor((HandshakeInterceptor)new LBAwareHandshakeInterceptor(iamAuthConfig));
        }
    }
}

