/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

class EndpointConnectionMetrics {
    private final String address;
    private long succeeded = 0L;
    private long unavailable = 0L;
    private long closing = 0L;
    private long dead = 0L;
    private long npe = 0L;
    private long nha = 0L;
    private long minMillis = 0L;
    private long maxMillis = 0L;
    private long totalMillis;

    EndpointConnectionMetrics(String address) {
        this.address = address;
    }

    void succeeded(long startMillis) {
        ++this.succeeded;
        this.updateTimings(startMillis);
    }

    void unavailable(long startMillis) {
        ++this.unavailable;
        this.updateTimings(startMillis);
    }

    void closing(long startMillis) {
        ++this.closing;
        this.updateTimings(startMillis);
    }

    void dead(long startMillis) {
        ++this.dead;
        this.updateTimings(startMillis);
    }

    void npe(long startMillis) {
        ++this.npe;
        this.updateTimings(startMillis);
    }

    void nha(long startMillis) {
        ++this.nha;
        this.updateTimings(startMillis);
    }

    public String getAddress() {
        return this.address;
    }

    public long getSucceededCount() {
        return this.succeeded;
    }

    public long getUnavailableCount() {
        return this.unavailable;
    }

    public long getClosingCount() {
        return this.closing;
    }

    public long getDeadCount() {
        return this.dead;
    }

    public long getNullPointerExceptionCount() {
        return this.npe;
    }

    public long getNoHostsAvailableCount() {
        return this.nha;
    }

    public long getMinTimeToAcquireMillis() {
        return this.minMillis;
    }

    public long getMaxTimeToAcquireMillis() {
        return this.maxMillis;
    }

    public long getTotalAttempts() {
        return this.succeeded + this.unavailable + this.closing + this.dead + this.npe + this.nha;
    }

    public double getAverageTimeToAcquireMillis() {
        return (double)this.totalMillis / (double)this.getTotalAttempts();
    }

    private void updateTimings(long startMillis) {
        long endMillis = System.currentTimeMillis();
        long duration = endMillis - startMillis;
        this.totalMillis += duration;
        if (duration > this.maxMillis) {
            this.maxMillis = duration;
        }
        if (duration < this.minMillis) {
            this.minMillis = duration;
        }
    }

    public String toString() {
        return String.format("%s [total: %s, succeeded: %s, unavailable: %s, closing: %s, dead: %s, npe: %s, nha: %s, minMillis: %s, maxMillis: %s, avgMillis: %.2f]", this.getAddress(), this.getTotalAttempts(), this.getSucceededCount(), this.getUnavailableCount(), this.getClosingCount(), this.getDeadCount(), this.getNullPointerExceptionCount(), this.getNoHostsAvailableCount(), this.getMinTimeToAcquireMillis(), this.getMaxTimeToAcquireMillis(), this.getAverageTimeToAcquireMillis());
    }
}

