/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.driver.exception.NoHostAvailableException;

public class RetryUtils {
    public static Result isRetryableException(Exception ex) {
        Throwable e = ExceptionUtils.getRootCause((Throwable)ex);
        Class<?> exceptionClass = e.getClass();
        String message = RetryUtils.getMessage(e);
        if (NoHostAvailableException.class.isAssignableFrom(exceptionClass)) {
            return Result.RETRYABLE(e, message);
        }
        if (ConnectException.class.isAssignableFrom(exceptionClass)) {
            return Result.RETRYABLE(e, message);
        }
        if (message.contains("Timed out while waiting for an available host") || message.contains("waiting for connection") || message.contains("Connection to server is no longer active") || message.contains("Connection reset by peer") || message.contains("Connection refused") || message.contains("SSLEngine closed already") || message.contains("Pool is shutdown") || message.contains("ExtendedClosedChannelException") || message.contains("Broken pipe") || message.contains("StacklessClosedChannelException")) {
            return Result.RETRYABLE(e, message);
        }
        if (message.contains("ConcurrentModificationException")) {
            return Result.RETRYABLE(e, message);
        }
        if (message.contains("ReadOnlyViolationException")) {
            return Result.RETRYABLE(e, message);
        }
        if (message.contains("ConstraintViolationException")) {
            return Result.RETRYABLE(e, message);
        }
        return Result.NOT_RETRYABLE(e, message);
    }

    private static String getMessage(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static class Result {
        private final boolean isRetryable;
        private final Throwable e;
        private final String message;

        private static Result RETRYABLE(Throwable e, String message) {
            return new Result(true, e, message);
        }

        private static Result NOT_RETRYABLE(Throwable e, String message) {
            return new Result(false, e, message);
        }

        public Result(boolean isRetryable, Throwable e, String message) {
            this.isRetryable = isRetryable;
            this.e = e;
            this.message = message;
        }

        public boolean isRetryable() {
            return this.isRetryable;
        }

        public Throwable rootCause() {
            return this.e;
        }

        public String message() {
            return this.message;
        }

        public String toString() {
            return "Result{isRetryable=" + this.isRetryable + ", e=" + this.e + ", message='" + this.message + '\'' + '}';
        }
    }
}

