/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Endpoint;

class EndpointClient {
    private final Endpoint endpoint;
    private final Client client;

    public static List<EndpointClient> create(Map<Endpoint, Cluster> endpointClusters) {
        return EndpointClient.create(endpointClusters, cluster -> cluster.connect().init());
    }

    static List<EndpointClient> create(Map<Endpoint, Cluster> endpointClusters, Function<Cluster, Client> clientFactory) {
        ArrayList<EndpointClient> results = new ArrayList<EndpointClient>();
        for (Map.Entry<Endpoint, Cluster> entry : endpointClusters.entrySet()) {
            Cluster cluster = entry.getValue();
            Endpoint endpoint = entry.getKey();
            Client client = clientFactory.apply(cluster);
            results.add(new EndpointClient(endpoint, client));
        }
        return results;
    }

    EndpointClient(Endpoint endpoint, Client client) {
        this.endpoint = endpoint;
        this.client = client;
    }

    public Endpoint endpoint() {
        return this.endpoint;
    }

    public Client client() {
        return this.client;
    }

    public void initClient() {
        this.client.init();
    }

    public CompletableFuture<Void> closeClientAsync() {
        return this.client.closeAsync();
    }
}

