/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.tracing.internal;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.entities.Subsegment;
import java.util.function.Supplier;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import software.amazon.lambda.powertools.core.internal.LambdaHandlerProcessor;
import software.amazon.lambda.powertools.tracing.Tracing;
import software.amazon.lambda.powertools.tracing.TracingUtils;
import software.amazon.lambda.powertools.tracing.internal.SystemWrapper;

@Aspect
public final class LambdaTracingAspect {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ LambdaTracingAspect ajc$perSingletonInstance;

    @Pointcut(value="@annotation(tracing)")
    public /* synthetic */ void callAt(Tracing tracing) {
    }

    @Around(value="callAt(tracing) && execution(@Tracing * *.*(..))", argNames="pjp,tracing")
    public Object around(ProceedingJoinPoint pjp, Tracing tracing) throws Throwable {
        Object[] proceedArgs = pjp.getArgs();
        Subsegment segment = AWSXRay.beginSubsegment((String)this.customSegmentNameOrDefault(tracing, () -> "## " + pjp.getSignature().getName()));
        segment.setNamespace(this.namespace(tracing));
        if (LambdaHandlerProcessor.isHandlerMethod((ProceedingJoinPoint)pjp)) {
            segment.putAnnotation("ColdStart", Boolean.valueOf(LambdaHandlerProcessor.isColdStart()));
            segment.putAnnotation("Service", this.namespace(tracing));
        }
        boolean captureResponse = this.captureResponse(tracing);
        boolean captureError = this.captureError(tracing);
        try {
            Object methodReturn = pjp.proceed(proceedArgs);
            if (captureResponse) {
                segment.putMetadata(this.namespace(tracing), String.valueOf(pjp.getSignature().getName()) + " response", TracingUtils.objectMapper() != null ? TracingUtils.objectMapper().writeValueAsString(methodReturn) : methodReturn);
            }
            if (LambdaHandlerProcessor.isHandlerMethod((ProceedingJoinPoint)pjp)) {
                LambdaHandlerProcessor.coldStartDone();
            }
            Object object = methodReturn;
            return object;
        }
        catch (Exception e) {
            if (captureError) {
                segment.putMetadata(this.namespace(tracing), String.valueOf(pjp.getSignature().getName()) + " error", TracingUtils.objectMapper() != null ? TracingUtils.objectMapper().writeValueAsString((Object)e) : e);
            }
            throw e;
        }
        finally {
            if (!LambdaHandlerProcessor.isSamLocal()) {
                AWSXRay.endSubsegment();
            }
        }
    }

    private boolean captureResponse(Tracing powerToolsTracing) {
        switch (powerToolsTracing.captureMode()) {
            case ENVIRONMENT_VAR: {
                boolean captureResponse = this.environmentVariable("POWERTOOLS_TRACER_CAPTURE_RESPONSE");
                return this.isEnvironmentVariableSet("POWERTOOLS_TRACER_CAPTURE_RESPONSE") ? captureResponse : powerToolsTracing.captureResponse();
            }
            case RESPONSE: 
            case RESPONSE_AND_ERROR: {
                return true;
            }
        }
        return false;
    }

    private boolean captureError(Tracing powerToolsTracing) {
        switch (powerToolsTracing.captureMode()) {
            case ENVIRONMENT_VAR: {
                boolean captureError = this.environmentVariable("POWERTOOLS_TRACER_CAPTURE_ERROR");
                return this.isEnvironmentVariableSet("POWERTOOLS_TRACER_CAPTURE_ERROR") ? captureError : powerToolsTracing.captureError();
            }
            case ERROR: 
            case RESPONSE_AND_ERROR: {
                return true;
            }
        }
        return false;
    }

    private String customSegmentNameOrDefault(Tracing powerToolsTracing, Supplier<String> defaultSegmentName) {
        String segmentName = powerToolsTracing.segmentName();
        return segmentName.isEmpty() ? defaultSegmentName.get() : segmentName;
    }

    private String namespace(Tracing powerToolsTracing) {
        return powerToolsTracing.namespace().isEmpty() ? LambdaHandlerProcessor.serviceName() : powerToolsTracing.namespace();
    }

    private boolean environmentVariable(String key) {
        return Boolean.parseBoolean(SystemWrapper.getenv(key));
    }

    private boolean isEnvironmentVariableSet(String key) {
        return SystemWrapper.containsKey(key);
    }

    public static LambdaTracingAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("software.amazon.lambda.powertools.tracing.internal.LambdaTracingAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            LambdaTracingAspect.ajc$perSingletonInstance = new LambdaTracingAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

