/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.parameters;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.lambda.powertools.parameters.BaseProvider;
import software.amazon.lambda.powertools.parameters.cache.CacheManager;
import software.amazon.lambda.powertools.parameters.exception.DynamoDbProviderSchemaException;
import software.amazon.lambda.powertools.parameters.transform.TransformationManager;

public class DynamoDbProvider
extends BaseProvider {
    private final DynamoDbClient client;
    private final String tableName;

    public DynamoDbProvider(CacheManager cacheManager, String tableName) {
        this(cacheManager, (DynamoDbClient)((DynamoDbClientBuilder)((DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().httpClientBuilder((SdkHttpClient.Builder)UrlConnectionHttpClient.builder())).credentialsProvider((AwsCredentialsProvider)EnvironmentVariableCredentialsProvider.create())).region(Region.of((String)System.getenv(SdkSystemSetting.AWS_REGION.environmentVariable())))).build(), tableName);
    }

    DynamoDbProvider(CacheManager cacheManager, DynamoDbClient client, String tableName) {
        super(cacheManager);
        this.client = client;
        this.tableName = tableName;
    }

    @Override
    protected String getValue(String key) {
        GetItemResponse resp = this.client.getItem((GetItemRequest)GetItemRequest.builder().tableName(this.tableName).key(Collections.singletonMap("id", AttributeValue.fromS((String)key))).attributesToGet(new String[]{"value"}).build());
        if (resp.hasItem() && !resp.item().values().isEmpty()) {
            if (!resp.item().containsKey("value")) {
                throw new DynamoDbProviderSchemaException("Missing 'value': " + resp.item().toString());
            }
            return ((AttributeValue)resp.item().get("value")).s();
        }
        return null;
    }

    @Override
    protected Map<String, String> getMultipleValues(String path) {
        QueryResponse resp = this.client.query((QueryRequest)QueryRequest.builder().tableName(this.tableName).keyConditionExpression("id = :v_id").expressionAttributeValues(Collections.singletonMap(":v_id", AttributeValue.fromS((String)path))).build());
        return resp.items().stream().peek(i -> {
            if (!i.containsKey("sk")) {
                throw new DynamoDbProviderSchemaException("Missing 'sk': " + i.toString());
            }
            if (!i.containsKey("value")) {
                throw new DynamoDbProviderSchemaException("Missing 'value': " + i.toString());
            }
        }).collect(Collectors.toMap(i -> ((AttributeValue)i.get("sk")).s(), i -> ((AttributeValue)i.get("value")).s()));
    }

    public static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private DynamoDbClient client;
        private String table;
        private CacheManager cacheManager;
        private TransformationManager transformationManager;

        Builder() {
        }

        public DynamoDbProvider build() {
            if (this.cacheManager == null) {
                throw new IllegalStateException("No CacheManager provided; please provide one");
            }
            if (this.table == null) {
                throw new IllegalStateException("No DynamoDB table name provided; please provide one");
            }
            DynamoDbProvider provider = this.client != null ? new DynamoDbProvider(this.cacheManager, this.client, this.table) : new DynamoDbProvider(this.cacheManager, this.table);
            if (this.transformationManager != null) {
                provider.setTransformationManager(this.transformationManager);
            }
            return provider;
        }

        public Builder withClient(DynamoDbClient client) {
            this.client = client;
            return this;
        }

        public Builder withCacheManager(CacheManager cacheManager) {
            this.cacheManager = cacheManager;
            return this;
        }

        public Builder withTable(String table) {
            this.table = table;
            return this;
        }

        public Builder withTransformationManager(TransformationManager transformationManager) {
            this.transformationManager = transformationManager;
            return this;
        }
    }
}

