/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.parameters;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.lambda.powertools.parameters.ParamProvider;
import software.amazon.lambda.powertools.parameters.cache.CacheManager;
import software.amazon.lambda.powertools.parameters.transform.TransformationManager;
import software.amazon.lambda.powertools.parameters.transform.Transformer;

@NotThreadSafe
public abstract class BaseProvider
implements ParamProvider {
    protected final CacheManager cacheManager;
    private TransformationManager transformationManager;
    private Clock clock;

    public BaseProvider(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    protected abstract String getValue(String var1);

    protected abstract Map<String, String> getMultipleValues(String var1);

    protected BaseProvider defaultMaxAge(int maxAge, ChronoUnit unit) {
        Duration duration = Duration.of(maxAge, unit);
        this.cacheManager.setDefaultExpirationTime(duration);
        return this;
    }

    public BaseProvider withMaxAge(int maxAge, ChronoUnit unit) {
        this.cacheManager.setExpirationTime(Duration.of(maxAge, unit));
        return this;
    }

    public BaseProvider withTransformation(Class<? extends Transformer> transformerClass) {
        if (this.transformationManager == null) {
            throw new IllegalStateException("Trying to add transformation while no TransformationManager has been provided.");
        }
        this.transformationManager.setTransformer(transformerClass);
        return this;
    }

    @Override
    public Map<String, String> getMultiple(String path) {
        String pathWithoutTrailingSlash = path.replaceAll("\\/+$", "");
        try {
            Map map = (Map)this.cacheManager.getIfNotExpired(pathWithoutTrailingSlash, this.now()).orElseGet(() -> {
                Map<String, String> params = this.getMultipleValues(pathWithoutTrailingSlash);
                this.cacheManager.putInCache(pathWithoutTrailingSlash, params);
                params.forEach((k, v) -> this.cacheManager.putInCache(String.valueOf(pathWithoutTrailingSlash) + "/" + k, v));
                return params;
            });
            return map;
        }
        finally {
            this.resetToDefaults();
        }
    }

    @Override
    public String get(String key) {
        try {
            String string = (String)this.cacheManager.getIfNotExpired(key, this.now()).orElseGet(() -> {
                String value;
                String transformedValue = value = this.getValue(key);
                if (this.transformationManager != null && this.transformationManager.shouldTransform()) {
                    transformedValue = this.transformationManager.performBasicTransformation(value);
                }
                this.cacheManager.putInCache(key, transformedValue);
                return transformedValue;
            });
            return string;
        }
        finally {
            this.resetToDefaults();
        }
    }

    @Override
    public <T> T get(String key, Class<T> targetClass) {
        try {
            Object object = this.cacheManager.getIfNotExpired(key, this.now()).orElseGet(() -> {
                String value = this.getValue(key);
                if (this.transformationManager == null) {
                    throw new IllegalStateException("Trying to transform value while no TransformationManager has been provided.");
                }
                Object transformedValue = this.transformationManager.performComplexTransformation(value, targetClass);
                this.cacheManager.putInCache(key, transformedValue);
                return transformedValue;
            });
            return (T)object;
        }
        finally {
            this.resetToDefaults();
        }
    }

    protected Instant now() {
        if (this.clock == null) {
            this.clock = Clock.systemDefaultZone();
        }
        return this.clock.instant();
    }

    protected void resetToDefaults() {
        this.cacheManager.resetExpirationTime();
        if (this.transformationManager != null) {
            this.transformationManager.setTransformer(null);
        }
    }

    protected void setTransformationManager(TransformationManager transformationManager) {
        this.transformationManager = transformationManager;
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }
}

