/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.internal;

import com.amazonaws.services.lambda.runtime.Context;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.DeclarePrecedence;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import software.amazon.lambda.powertools.common.internal.LambdaHandlerProcessor;
import software.amazon.lambda.powertools.logging.Logging;
import software.amazon.lambda.powertools.logging.PowertoolsLogging;
import software.amazon.lambda.powertools.logging.argument.StructuredArguments;
import software.amazon.lambda.powertools.logging.internal.BufferManager;
import software.amazon.lambda.powertools.logging.internal.LoggingConstants;
import software.amazon.lambda.powertools.logging.internal.LoggingManager;
import software.amazon.lambda.powertools.logging.internal.LoggingManagerRegistry;
import software.amazon.lambda.powertools.utilities.JsonConfig;

@Aspect
@DeclarePrecedence(value="*, software.amazon.lambda.powertools.logging.internal.LambdaLoggingAspect")
public final class LambdaLoggingAspect {
    private static final Logger LOG = LoggerFactory.getLogger(LambdaLoggingAspect.class);
    private static final LoggingManager LOGGING_MANAGER = LoggingManagerRegistry.getLoggingManager();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ LambdaLoggingAspect ajc$perSingletonInstance;

    static {
        try {
            LambdaLoggingAspect.ajc$perSingletonInstance = new LambdaLoggingAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="@annotation(logging)")
    public /* synthetic */ void callAt(Logging logging) {
    }

    @Around(value="callAt(logging) && execution(@Logging * *.*(..))", argNames="pjp,logging")
    public Object around(ProceedingJoinPoint pjp, Logging logging) throws Throwable {
        Object lambdaFunctionResponse;
        boolean isOnRequestHandler = LambdaHandlerProcessor.placedOnRequestHandler((ProceedingJoinPoint)pjp);
        boolean isOnRequestStreamHandler = LambdaHandlerProcessor.placedOnStreamHandler((ProceedingJoinPoint)pjp);
        Context context = LambdaHandlerProcessor.extractContext((ProceedingJoinPoint)pjp);
        Object[] proceedArgs = pjp.getArgs();
        if (LambdaHandlerProcessor.isHandlerMethod((ProceedingJoinPoint)pjp) && context != null) {
            Object event = this.extractEventForCorrelationId(logging, isOnRequestHandler, isOnRequestStreamHandler, proceedArgs);
            PowertoolsLogging.initializeLogging(context, logging.samplingRate(), logging.correlationIdPath().isEmpty() ? null : logging.correlationIdPath(), event);
        }
        this.logEvent(pjp, logging, isOnRequestHandler, isOnRequestStreamHandler, proceedArgs);
        OutputStream backupOutputStream = null;
        if (isOnRequestStreamHandler) {
            backupOutputStream = this.prepareOutputStreamForLogging(logging, proceedArgs);
        }
        try {
            try {
                lambdaFunctionResponse = pjp.proceed(proceedArgs);
            }
            catch (Throwable t) {
                this.handleException(pjp, logging, t);
                throw t;
            }
        }
        finally {
            PowertoolsLogging.clearState(logging.clearState());
        }
        this.logResponse(pjp, logging, lambdaFunctionResponse, isOnRequestHandler, isOnRequestStreamHandler, backupOutputStream, proceedArgs);
        return lambdaFunctionResponse;
    }

    private void logEvent(ProceedingJoinPoint pjp, Logging logging, boolean isOnRequestHandler, boolean isOnRequestStreamHandler, Object[] proceedArgs) {
        if (logging.logEvent() || LoggingConstants.POWERTOOLS_LOG_EVENT) {
            if (isOnRequestHandler) {
                this.logRequestHandlerEvent(pjp, proceedArgs[0]);
            } else if (isOnRequestStreamHandler) {
                this.logRequestStreamHandlerEvent(pjp, proceedArgs);
            }
        }
    }

    private void logRequestHandlerEvent(ProceedingJoinPoint pjp, Object event) {
        Logger log = this.logger(pjp);
        if (log.isInfoEnabled()) {
            log.info("Handler Event", (Object)StructuredArguments.entry("event", event));
        }
    }

    private void logRequestStreamHandlerEvent(ProceedingJoinPoint pjp, Object[] args) {
        Logger log = this.logger(pjp);
        if (log.isInfoEnabled()) {
            try {
                byte[] bytes = this.bytesFromInputStreamSafely((InputStream)args[0]);
                args[0] = new ByteArrayInputStream(bytes);
                log.info("Handler Event", (Object)StructuredArguments.entry("event", new String(bytes, StandardCharsets.UTF_8)));
            }
            catch (IOException e) {
                LOG.warn("Failed to log event from supplied input stream.", (Throwable)e);
            }
        }
    }

    private void logRequestHandlerResponse(ProceedingJoinPoint pjp, Object response) {
        Logger log = this.logger(pjp);
        if (log.isInfoEnabled()) {
            log.info("Handler Response", (Object)StructuredArguments.entry("response", response));
        }
    }

    private void logRequestStreamHandlerResponse(ProceedingJoinPoint pjp, byte[] bytes) {
        Logger log = this.logger(pjp);
        if (log.isInfoEnabled()) {
            log.info("Handler Response", (Object)StructuredArguments.entry("response", new String(bytes, StandardCharsets.UTF_8)));
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] bytesFromInputStreamSafely(InputStream inputStream) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private OutputStream prepareOutputStreamForLogging(Logging logging, Object[] proceedArgs) {
        if (logging.logResponse() || LoggingConstants.POWERTOOLS_LOG_RESPONSE) {
            OutputStream backupOutputStream = (OutputStream)proceedArgs[1];
            proceedArgs[1] = new ByteArrayOutputStream();
            return backupOutputStream;
        }
        return null;
    }

    private void handleException(ProceedingJoinPoint pjp, Logging logging, Throwable t) {
        if (LOGGING_MANAGER instanceof BufferManager) {
            if (logging.flushBufferOnUncaughtError()) {
                ((BufferManager)((Object)LOGGING_MANAGER)).flushBuffer();
            } else {
                ((BufferManager)((Object)LOGGING_MANAGER)).clearBuffer();
            }
        }
        if (logging.logError() || LoggingConstants.POWERTOOLS_LOG_ERROR) {
            this.logger(pjp).error(MarkerFactory.getMarker((String)"FATAL"), "Exception in Lambda Handler", t);
        }
    }

    private void logResponse(ProceedingJoinPoint pjp, Logging logging, Object lambdaFunctionResponse, boolean isOnRequestHandler, boolean isOnRequestStreamHandler, OutputStream backupOutputStream, Object[] proceedArgs) throws IOException {
        if (logging.logResponse() || LoggingConstants.POWERTOOLS_LOG_RESPONSE) {
            if (isOnRequestHandler) {
                this.logRequestHandlerResponse(pjp, lambdaFunctionResponse);
            } else if (isOnRequestStreamHandler && backupOutputStream != null) {
                byte[] bytes = ((ByteArrayOutputStream)proceedArgs[1]).toByteArray();
                this.logRequestStreamHandlerResponse(pjp, bytes);
                backupOutputStream.write(bytes);
            }
        }
    }

    private Object extractEventForCorrelationId(Logging logging, boolean isOnRequestHandler, boolean isOnRequestStreamHandler, Object[] proceedArgs) {
        if (logging.correlationIdPath().isEmpty()) {
            return null;
        }
        if (isOnRequestHandler && proceedArgs.length > 0) {
            return proceedArgs[0];
        }
        if (isOnRequestStreamHandler && proceedArgs.length > 0) {
            try {
                byte[] bytes = this.bytesFromInputStreamSafely((InputStream)proceedArgs[0]);
                JsonNode event = JsonConfig.get().getObjectMapper().readTree(bytes);
                proceedArgs[0] = new ByteArrayInputStream(bytes);
                return event;
            }
            catch (IOException e) {
                LOG.warn("Failed to read event from input stream for correlation ID extraction.", (Throwable)e);
            }
        }
        return null;
    }

    private Logger logger(ProceedingJoinPoint pjp) {
        return LoggerFactory.getLogger((Class)pjp.getSignature().getDeclaringType());
    }

    public static LambdaLoggingAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("software.amazon.lambda.powertools.logging.internal.LambdaLoggingAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

